import App from './App'
import net from './common/net.js'
import store from './store/index.js'
import numUtils from './common/numUtil.js'
import router from './router/router.js'
import toast from './common/toast.js'
import loading from './common/loading.js'

// #ifndef VUE3
import Vue from 'vue'
Vue.config.productionTip = false
App.mpType = 'app'
Vue.prototype.$net = net
Vue.prototype.$store = store
Vue.prototype.$router = router
Vue.prototype.$numUtils = numUtils
Vue.prototype.toast = toast
Vue.prototype.loading = loading
const app = new Vue({
    ...App
})
app.$mount()
// #endif

// #ifdef VUE3
import { createSSRApp } from 'vue'
export function createApp() {
  const app = createSSRApp(App)
  return {
    app
  }
}
// #endif