import store from '../store/index.js';

export function openAlbumSetting() {
	uni.showModal({
		title:'提示',
		content:'请打开相册权限',
		showCancel:true,
		cancelText:'取消',
		confirmText:'确定',
		cancelColor:'#000000',
		confirmColor:'#3CC51F',
		success(res) {
			if (res.confirm) {
				wx.openSetting({
					success(res) {
						console.log('重新授权成功', res);
					},
					fail(err) {
						console.log('重新授权失败', err);
					}
				})
			} else {
				
			}
		}
	})
}

export function getSettingScope (type='scope.userLocation') {
	return new Promise((resolve, reject)=>{
		wx.authorize({
			scope:type,
			success(res) {
				console.log(res);
				resolve(res)
			},
			fail(err) {
				console.log(err);
				reject(err)
			}
		})
	})
}

export default {
	openAlbumSetting: openAlbumSetting,
	getSettingScope: getSettingScope
}