// 加法运算
export function numAdd (num1, num2) {
  var r1, r2, m, c
  try {
    r1 = num1.toString().split('.')[1].length
  } catch (e) {
    r1 = 0
  }
  try {
    r2 = num2.toString().split('.')[1].length
  } catch (e) {
    r2 = 0
  }
  c = Math.abs(r1 - r2)
  m = Math.pow(10, Math.max(r1, r2))
  if (c > 0) {
    var cm = Math.pow(10, c)
    if (r1 > r2) {
      num1 = Number(num1.toString().replace('.', ''))
      num2 = Number(num2.toString().replace('.', '')) * cm
    } else {
      num1 = Number(num1.toString().replace('.', '')) * cm
      num2 = Number(num2.toString().replace('.', ''))
    }
  } else {
    num1 = Number(num1.toString().replace('.', ''))
    num2 = Number(num2.toString().replace('.', ''))
  }
  return (num1 + num2) / m
}

// 减法运算
export function numSub (data1, data2) {
  var num, num1, num2
  var precision // 精度
  try {
    num1 = data1.toString().split('.')[1].length
  } catch (e) {
    num1 = 0
  }
  try {
    num2 = data2.toString().split('.')[1].length
  } catch (e) {
    num2 = 0
  }
  num = Math.pow(10, Math.max(num1, num2))
  precision = (num1 >= num2) ? num1 : num2
  return ((data1 * num - data2 * num) / num).toFixed(precision)
}

/**
 * 乘法运算，避免数据相乘小数点后产生多位数和计算精度损失。
 *
 * @param num1被乘数 | num2乘数
 */
export function numMulti (data1, data2) {
  var baseData = 0
  try {
    baseData += data1.toString().split('.')[1].length
  } catch (e) {}
  try {
    baseData += data2.toString().split('.')[1].length
  } catch (e) {}
  return Number(data1.toString().replace('.', '')) * Number(data2.toString().replace('.', '')) / Math.pow(10, baseData)
};

export function numDivision(arg1, arg2){ 
	console.log(arg1, arg2);
	var t1=0,t2=0,r1,r2; 
	try{t1=arg1.toString().split(".")[1].length}catch(e){}
	try{t2=arg2.toString().split(".")[1].length}catch(e){} 
	r1=Number(arg1.toString().replace(".","")) 
	r2=Number(arg2.toString().replace(".","")) 
	return (r1/r2)*Math.pow(10,t2-t1);
}

export function getGoodsPrice (goods, type='home') {
	if (!goods) {
		return ''
	}
	let integral = goods.integral || 0
	let price = 0
	if (type=='order') {
		price = goods.payCash
	}else if (type=='orderDetail') {
		price = numSub(goods.payCash || 0, goods.freight || 0)
	} else {
		price= goods.price
	}
	if (integral>0 && price>0) {
		return integral+'积分+'+price+'元'
	} else if (integral>0 && price<=0) {
		return integral+'积分'
	} else if (integral<=0 && price>0) {
		return price+'元'
	} else {
		return '0积分'
	}
}

export function moneyFormat(num,counts,mark){
    num = num.toString().split(".");
    var tempAry = num[0].split("").reverse();
    var res=[];
    for(var i=0,len=tempAry.length;i<len;i++){
        if(i%counts===0&&i!==0){
            res.push(mark); 
        }
        res.push(tempAry[i]);
    }
    res.reverse();
    if(num[1]){ 
        res=res.join("").concat("."+num[1]);
    }else{
        res=res.join("");
    }

    return res;
}

export default {
	numAdd: numAdd,
	numSub: numSub,
	numMulti: numMulti,
	numDivision: numDivision,
	getGoodsPrice: getGoodsPrice,
	moneyFormat: moneyFormat
}