package com.lanren.huhu.partner.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.lanren.huhu.partner.dao.UserAgentMapper;
import com.lanren.huhu.partner.domain.UserAgent;
import com.lanren.huhu.partner.model.ParentAgent;
import com.lanren.huhu.partner.service.UserAgentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author chen
 */
@Service
public class UserAgentServiceImpl extends ServiceImpl<UserAgentMapper, UserAgent> implements UserAgentService {
    private static Logger logger = LoggerFactory.getLogger(UserAgentServiceImpl.class);

//    @Autowired
//    UserAgentMapper userAgentMapper;

    @Override
    public int updateBatch(List<UserAgent> list) {
        return baseMapper.updateBatch(list);
    }

    @Override
    public int batchInsert(List<UserAgent> list) {
        return baseMapper.batchInsert(list);
    }

    @Override
    public int insertOrUpdate(UserAgent record) {
        return baseMapper.insertOrUpdate(record);
    }

    @Override
    public int insertOrUpdateSelective(UserAgent record) {
        return baseMapper.insertOrUpdateSelective(record);
    }

    @Override
    public UserAgent getOneByAgentId(Integer agentId) {
        QueryWrapper<UserAgent> queryWrapper = new QueryWrapper<UserAgent>();
        queryWrapper.eq("agent_id", agentId)
                .le("agent_level", 4)
        ;
        return baseMapper.selectOne(queryWrapper);
    }

    @Override
    public List<ParentAgent> getParentAgentListByAgentId(Integer agentId, String parentColumnName) {
        List<ParentAgent> parentList = new ArrayList<ParentAgent>();
        int loogAgentId = agentId;
        int loopTimes = 0;
        while (true) {
            ParentAgent parentAgent = getParentAgentByAgentId(loogAgentId, parentColumnName);
            if (null == parentAgent) {
                break;
            } else {
                if (parentList.contains(parentAgent) || parentAgent.getAgentId() == agentId) {
                    logger.info("发现互为上级的代理关系 代理商({})", parentAgent.getAgentId());
                    logger.info("退出循环, 不再继续查找");
                    break;
                }
                parentList.add(parentAgent);
                loogAgentId = parentAgent.getAgentId();
                loopTimes++;
                if (loopTimes > 500) {
                    parentList.clear();
                    logger.error("代理商:{} 邀请关系异常, 已超500层", agentId);
                    break;
                }
            }
        }
        return parentList;
    }

    @Override
    public ParentAgent getParentAgentByAgentId(Integer agentId, String parentColumnName) {
        UserAgent userAgent = baseMapper.getParentAgent(agentId, parentColumnName);
        if (userAgent != null) {
            return new ParentAgent(userAgent.getUserId(), userAgent.getAgentId(), userAgent.getAgentLevel());
        } else {
            return null;
        }
    }
}
