package com.lanren.huhu.partner.service;

import com.lanren.huhu.partner.domain.PartnerAccount;
import com.lanren.huhu.partner.domain.UserAgent;
import com.lanren.huhu.partner.model.ParentAgent;
import com.lanren.huhu.partner.model.User;

import java.util.List;

/**
 * @author houseme
 * @date 2019-06-28 18:35
 * @Project partner
 * @Package com.lanren.huhu.partner.service
 * @File: UserService
 */
public interface UserService {
    /**
     * @description: 根据用户id, 查找一个用户的全部合伙人上级 和 代理商上级(此处为层级关系 非平推关系)
     *       缓存用户邀请关系和代理商关系数据
     *       缓存不能带有构造方法的Bean 所以只能返回User的Bean
     *       包装Result在Cacheable注解的方法之外进行操作
     * 注意 !!!!!!!!  这个方法是按输入用户的邀请关系链上查找 第一个有agent_level<=4的代理商身份的邀请人, 然后再走他的代理关系
     * 注意 !!!!!!!!  如果需要获取一个代理商的上级代理 需要从UserAgentService里的方法获取
     * @param userId
     * @return User
     * @throws
     * @author chen
     * @date 2019-06-26 20:01
     */
    User getRelationByUserId(Integer userId);

    List<ParentAgent> getAgentListByUserId(Integer userId, String parentColumnName);

    /**
     * 清理用户缓存
     */
    boolean deleteRalationByUserId(Integer userId);

    /***
     * PartnerAccount
     *
     * 根据用户id查询账户信息
     * @param userId
     * @return PartnerAccount
     */
    PartnerAccount getPartnerAccountByUserId(Integer userId);
    /**
     * @description: 根据用户id查询全部直属下级合伙人
     * @param userId
     * @return List<PartnerAccount>
     * @author chen
     * @date 2019-06-28 11:49
     */
    List<PartnerAccount> getPartnerAccountChildListByUserId(Integer userId);

    /***
     * UserAgent
     * 根据用户id查询账户信息
     * @param userId
     * @return
     */
    UserAgent getUserAgentByUserId(Integer userId);
    /**
     * @description: 根据用户id查询全部直属下级代理商
     * @param userId
     * @return List<PartnerAccount>
     * @author chen
     * @date 2019-06-28 11:49
     */
    List<UserAgent> getUserAgentChildListByUserId(Integer userId, String parentColumnName);

    int updatePartnerRelation(String from, String to);

    int updatePingtuiRelation(String from, String to);

    int updateCengjiRelation(String from, String to);

    PartnerAccount getPartnerAccountByPhone(String phone);
}