package com.lanren.huhu.partner.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.lanren.huhu.partner.domain.UserAgent;
import com.lanren.huhu.partner.model.ParentAgent;

import java.util.List;

public interface UserAgentService extends IService<UserAgent> {

    int updateBatch(List<UserAgent> list);

    int batchInsert(List<UserAgent> list);

    int insertOrUpdate(UserAgent record);

    int insertOrUpdateSelective(UserAgent record);

    /***
     * 根据代理商id查询账户信息
     * @param agentId
     * @return
     */
    UserAgent getOneByAgentId(Integer agentId);

    /**
     * @description: 查找一个用户的直接代理商上级, 根据字段presenter_id
     * @param agentId
     * @return ParentAgent
     */
    ParentAgent getParentAgentByAgentId(Integer agentId, String parentColumnName);
    /**
     * @description: 查找一个用户的全部直属代理商上级, 根据字段presenter_id
     * @param agentId
     * @return List<ParentAgent>
     */
    List<ParentAgent> getParentAgentListByAgentId(Integer agentId, String parentColumnName);
}
