package com.lanren.huhu.partner.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.lanren.huhu.partner.domain.PartnerReward;
import com.lanren.huhu.partner.model.PartnerSettle;

import java.util.List;

/**
 * @author chen
 * @title: ${NAME}
 * @projectName partner
 * @description: 合伙人奖g明细
 * @package ${PACKAGE_NAME}
 * @date 2019-07-02 14:54
 */
public interface PartnerRewardService extends IService<PartnerReward> {


    int updateBatch(List<PartnerReward> list);

    int batchInsert(List<PartnerReward> list);

    int insertOrUpdate(PartnerReward record);

    int insertOrUpdateSelective(PartnerReward record);

    /**
     * 涉及订单佣金相关的奖励: 自购省/分享赚
     */
    IPage<PartnerReward> selectOrderRewardPageByTs(Page<PartnerReward> page, Long beginTs, Long endTs);

    IPage<PartnerReward> selectOrderRewardPageByTsAndUid(Page<PartnerReward> page, Long beginTs, Long endTs, Integer userId);

    /**
     * 获取每个合伙人的汇总收入
     */
    IPage<PartnerSettle> selectPartnerSettlePageByTs(Page<PartnerSettle> page, Long beginTs, Long endTs);
    /**
     * 获取单个合伙人的汇总收入
     */
    PartnerSettle selectPartnerSettlePageByTsAndUid(Long beginTs, Long endTs, Integer userId);
    /**
     * 更新奖励状态
     */
    int updateRewardStatusByUidAndTs(Integer userId, Long beginTs, Long endTs);
}

