package com.lanren.huhu.partner.model;

import com.lanren.huhu.partner.model.base.BaseModel;
import lombok.Data;

/**
 * @author chen
 * @title: ParentPartner
 * @projectName partner
 * @description: 上级合伙人
 * @package com.lanren.huhu.partner.model
 * @date 2019-06-2711:20
 */
@Data
public class ParentPartner extends BaseModel {
    int userId;
    int level;

    public ParentPartner(int userId, int level) {
        this.userId = userId;
        this.level = level;
    }

    @Override
    public boolean equals(Object obj) {
        if(obj==null) {
            return false;
        }
        if(this==obj) {
            return true;
        }
        if(obj instanceof ParentPartner){
            ParentPartner parentPartner = (ParentPartner) obj;
            if(parentPartner.userId == this.userId) {
                return true;
            } else {
                return false;
            }
        }
        return false;
    }
}
