package com.lanren.huhu.partner.model;

import com.lanren.huhu.partner.model.base.BaseModel;
import lombok.Data;

/**
 * @author chen
 * @title: ParentAgent
 * @projectName partner
 * @description: 上级代理商
 * @package com.lanren.huhu.partner.model
 * @date 2019-06-2711:20
 */
@Data
public class ParentAgent extends BaseModel {
    int userId;
    int agentId;
    int level;

    public ParentAgent(int userId, int agentId, int level) {
        this.userId = userId;
        this.agentId = agentId;
        this.level = level;
    }

    @Override
    public boolean equals(Object obj) {
        if(obj==null) {
            return false;
        }
        if(this==obj) {
            return true;
        }
        if(obj instanceof ParentAgent){
            ParentAgent parentAgent = (ParentAgent) obj;
            if(parentAgent.agentId == this.agentId) {
                return true;
            } else {
                return false;
            }
        }
        return false;
    }
}
