package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

@Data
@TableName(value = "partner_invite_relation")
public class PartnerInviteRelation implements Serializable {
     @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 用户ID
     */
    @TableField(value = "user_id")
    private Integer userId;

    /**
     * 直接邀请的数量
     */
    @TableField(value = "direct_num")
    private Integer directNum;

    /**
     * 间接邀请的数量
     */
    @TableField(value = "indirect_num")
    private Integer indirectNum;

    /**
     * 合伙人等级 普通10 高级20 超级30
     */
    @TableField(value = "partner_level")
    private Integer partnerLevel;

    /**
     * 邀请类型 默认0无邀请 ，10邀请码邀请 20绑卡邀请
     */
    @TableField(value = "invite_type")
    private Integer inviteType;

    /**
     * 注册时间 用户注册时间
     */
    @TableField(value = "regiter_time")
    private Integer regiterTime;

    /**
     * 代理商ID
     */
    @TableField(value = "agent_id")
    private Integer agentId;

    /**
     * 关联代理商等级
     */
    @TableField(value = "parent_agent_list")
    private String parentAgentList;

    /**
     * 激活得订单号
     */
    @TableField(value = "active_order_id")
    private String activeOrderId;

    /**
     * 邀请者ID
     */
    @TableField(value = "invite_user_id")
    private Integer inviteUserId;

    /**
     * 邀请者得合伙人等级 默认0 10普通 20 高级 30超级
     */
    @TableField(value = "invite_partner_level")
    private Integer invitePartnerLevel;

    /**
     * 奖励金额
     */
    @TableField(value = "amount")
    private BigDecimal amount;

    /**
     * 默认0、10现金 20 红包
     */
    @TableField(value = "reward_type")
    private Integer rewardType;

    /**
     * 直接邀请奖励对应产品Id
     */
    @TableField(value = "coupon_id")
    private Integer couponId;

    /**
     * 间接邀请者id
     */
    @TableField(value = "indirect_invite_uid")
    private Integer indirectInviteUid;

    /**
     * 邀请者得合伙人等级 默认0 10普通 20 高级 30超级
     */
    @TableField(value = "indirect_partner_level")
    private Integer indirectPartnerLevel;

    /**
     * 奖励金额
     */
    @TableField(value = "indirect_amount")
    private BigDecimal indirectAmount;

    /**
     * 默认0、10现金 20 红包
     */
    @TableField(value = "indirect_reward_type")
    private Integer indirectRewardType;

    /**
     * 间接邀请奖励对应产品Id
     */
    @TableField(value = "indirect_coupon_id")
    private Integer indirectCouponId;

    /**
     * 默认0 90已注册 100待奖励 120 已奖励 激活时由90->100
     */
    @TableField(value = "state")
    private Integer state;

    /**
     * 激活时间 首单激活时间 张高伟写入
     */
    @TableField(value = "active_time")
    private Integer activeTime;

    /**
     * 结算时间 有关晨更新
     */
    @TableField(value = "settle_time")
    private Integer settleTime;

    /**
     * 创建时间
     */
    @TableField(value = "created_at")
    private Integer createdAt;

    /**
     * 修改时间
     */
    @TableField(value = "updated_at")
    private Integer updatedAt;

    /**
     * 最后有效的订单贡献奖励
     */
    @TableField(value = "last_active_order_id")
    private String lastActiveOrderId;

    /**
     * level1 id
     */
    @TableField(value = "agent_level_one")
    private Integer agentLevelOne;

    /**
     * level2 id
     */
    @TableField(value = "agent_level_two")
    private Integer agentLevelTwo;

    /**
     * level3 id
     */
    @TableField(value = "agent_level_three")
    private Integer agentLevelThree;

    /**
     * level4 id
     */
    @TableField(value = "agent_level_four")
    private Integer agentLevelFour;

    /**
     * level5 id
     */
    @TableField(value = "agent_level_five")
    private Integer agentLevelFive;

    private static final long serialVersionUID = 1L;

    public static final String COL_USER_ID = "user_id";

    public static final String COL_DIRECT_NUM = "direct_num";

    public static final String COL_INDIRECT_NUM = "indirect_num";

    public static final String COL_PARTNER_LEVEL = "partner_level";

    public static final String COL_INVITE_TYPE = "invite_type";

    public static final String COL_REGITER_TIME = "regiter_time";

    public static final String COL_AGENT_ID = "agent_id";

    public static final String COL_PARENT_AGENT_LIST = "parent_agent_list";

    public static final String COL_ACTIVE_ORDER_ID = "active_order_id";

    public static final String COL_INVITE_USER_ID = "invite_user_id";

    public static final String COL_INVITE_PARTNER_LEVEL = "invite_partner_level";

    public static final String COL_AMOUNT = "amount";

    public static final String COL_REWARD_TYPE = "reward_type";

    public static final String COL_COUPON_ID = "coupon_id";

    public static final String COL_INDIRECT_INVITE_UID = "indirect_invite_uid";

    public static final String COL_INDIRECT_PARTNER_LEVEL = "indirect_partner_level";

    public static final String COL_INDIRECT_AMOUNT = "indirect_amount";

    public static final String COL_INDIRECT_REWARD_TYPE = "indirect_reward_type";

    public static final String COL_INDIRECT_COUPON_ID = "indirect_coupon_id";

    public static final String COL_STATE = "state";

    public static final String COL_ACTIVE_TIME = "active_time";

    public static final String COL_SETTLE_TIME = "settle_time";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";

    public static final String COL_LAST_ACTIVE_ORDER_ID = "last_active_order_id";

    public static final String COL_AGENT_LEVEL_ONE = "agent_level_one";

    public static final String COL_AGENT_LEVEL_TWO = "agent_level_two";

    public static final String COL_AGENT_LEVEL_THREE = "agent_level_three";

    public static final String COL_AGENT_LEVEL_FOUR = "agent_level_four";

    public static final String COL_AGENT_LEVEL_FIVE = "agent_level_five";
}