package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Data;

@Data
@TableName(value = "orders_active")
public class OrdersActive implements Serializable {
    /**
     * id序号
     */
     @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 系统订单号
     */
    @TableField(value = "order_id")
    private String orderId;

    /**
     * 用户id
     */
    @TableField(value = "user_id")
    private Integer userId;

    /**
     * 订单号
     */
    @TableField(value = "order_sn")
    private String orderSn;

    /**
     * 订单类型 taobao:淘宝,jd:京东
     */
    @TableField(value = "type")
    private String type;

    /**
     * 标题
     */
    @TableField(value = "title")
    private String title;

    /**
     * 已激活用户显示当前佣金, 新用户显示预估佣金
     */
    @TableField(value = "commission_snapshot")
    private BigDecimal commissionSnapshot;

    /**
     * 预估佣金(不乘百分比的值)
     */
    @TableField(value = "estimate_effect")
    private BigDecimal estimateEffect;

    /**
     * 实际结算佣金(商家给呼呼结算的佣金)
     */
    @TableField(value = "commission_amount")
    private BigDecimal commissionAmount;

    /**
     * 维权退款返还佣金
     */
    @TableField(value = "refund_amount")
    private BigDecimal refundAmount;

    /**
     * 乘系数之前的给用户返佣金额（暂定）
     */
    @TableField(value = "all_money")
    private BigDecimal allMoney;

    /**
     * 结算金额(最终给用户结算金额)
     */
    @TableField(value = "money")
    private BigDecimal money;

    /**
     * 0未付款 1付款 3 结算 -3失效
     */
    @TableField(value = "status")
    private Integer status;

    /**
     * 订单创建时间
     */
    @TableField(value = "create_time")
    private LocalDateTime createTime;

    /**
     * 结算时间
     */
    @TableField(value = "settle_time")
    private LocalDateTime settleTime;

    /**
     * 倒计时最后时间
     */
    @TableField(value = "last_time")
    private LocalDateTime lastTime;

    /**
     * 用户实际支付金额
     */
    @TableField(value = "amount")
    private BigDecimal amount;

    /**
     * 是否是新人专享
     */
    @TableField(value = "is_for_new")
    private Integer isForNew;

    /**
     * 呼呼补贴金额快照
     */
    @TableField(value = "huhu_subsidy_snapshot")
    private BigDecimal huhuSubsidySnapshot;

    /**
     * 呼呼补贴金额实际
     */
    @TableField(value = "huhu_subsidy_actual")
    private BigDecimal huhuSubsidyActual;

    /**
     * 100 待激活 200 待结算 300 已结算 -100已失效
     */
    @TableField(value = "active_state")
    private Integer activeState;

    /**
     * 提交时间
     */
    @TableField(value = "post_time")
    private LocalDateTime postTime;

    /**
     * 激活时间
     */
    @TableField(value = "active_time")
    private LocalDateTime activeTime;

    /**
     * 创建时间
     */
    @TableField(value = "created_at")
    private Integer createdAt;

    /**
     * 系统结算时间
     */
    @TableField(value = "updated_at")
    private Integer updatedAt;

    /**
     * 是否预付订金订单 1是0否
     */
    @TableField(value = "has_deposit")
    private Integer hasDeposit;

    /**
     * 首提金额 0.00 默认不是首提
     */
    @TableField(value = "first_withdraw_cash")
    private BigDecimal firstWithdrawCash;

    /**
     * 是否首提 0否1是
     */
    @TableField(value = "is_first_withdraw")
    private Boolean isFirstWithdraw;

    /**
     * 是否拆单 0否1是
     */
    @TableField(value = "is_split_order")
    private Boolean isSplitOrder;

    /**
     * 父订单号
     */
    @TableField(value = "parent_order_sn")
    private String parentOrderSn;

    /**
     * 是否给合伙人奖励1不给0给
     */
    @TableField(value = "no_invite_reward")
    private Boolean noInviteReward;

    /**
     * 商品购买数量
     */
    @TableField(value = "goods_cnt")
    private Integer goodsCnt;

    /**
     * 订单状态200:待兑换 ;100:已兑换; 300:已失效
     */
    @TableField(value = "order_state")
    private Integer orderState;

    /**
     * 金额结算的父订单号
     */
    @TableField(value = "settlement_parent_order_sn")
    private String settlementParentOrderSn;

    /**
     * 是否结余订单(尾款单) 0：否；1：是
     */
    @TableField(value = "is_surplus_order")
    private Integer isSurplusOrder;

    /**
     * 是否消费红包，100消费  200不消费 0默认
     */
    @TableField(value = "is_consume_money")
    private Integer isConsumeMoney;

    /**
     * 是否可以提前结算的订单100 不是 200是提前7天 300是秒提
     */
    @TableField(value = "is_advance_settle_order")
    private Integer isAdvanceSettleOrder;

    /**
     * 激活订单的身份快照   0普通 100高级月vip 200高级半年vip 300高级年度vip 400超级月vip 500 超级年度vip
     */
    @TableField(value = "active_identity")
    private Integer activeIdentity;

    /**
     * 是否推送过结算任务0否1是
     */
    @TableField(value = "is_push_settle_task")
    private Integer isPushSettleTask;

    /**
     * 默认0 100助力 80非
     */
    @TableField(value = "is_assist")
    private Integer isAssist;

    /**
     * 最高比例
     */
    @TableField(value = "max_rate")
    private BigDecimal maxRate;

    /**
     * 最低比例
     */
    @TableField(value = "mini_rate")
    private BigDecimal miniRate;

    private static final long serialVersionUID = 1L;

    public static final String COL_ORDER_ID = "order_id";

    public static final String COL_USER_ID = "user_id";

    public static final String COL_ORDER_SN = "order_sn";

    public static final String COL_TYPE = "type";

    public static final String COL_TITLE = "title";

    public static final String COL_COMMISSION_SNAPSHOT = "commission_snapshot";

    public static final String COL_ESTIMATE_EFFECT = "estimate_effect";

    public static final String COL_COMMISSION_AMOUNT = "commission_amount";

    public static final String COL_REFUND_AMOUNT = "refund_amount";

    public static final String COL_ALL_MONEY = "all_money";

    public static final String COL_MONEY = "money";

    public static final String COL_STATUS = "status";

    public static final String COL_CREATE_TIME = "create_time";

    public static final String COL_SETTLE_TIME = "settle_time";

    public static final String COL_LAST_TIME = "last_time";

    public static final String COL_AMOUNT = "amount";

    public static final String COL_IS_FOR_NEW = "is_for_new";

    public static final String COL_HUHU_SUBSIDY_SNAPSHOT = "huhu_subsidy_snapshot";

    public static final String COL_HUHU_SUBSIDY_ACTUAL = "huhu_subsidy_actual";

    public static final String COL_ACTIVE_STATE = "active_state";

    public static final String COL_POST_TIME = "post_time";

    public static final String COL_ACTIVE_TIME = "active_time";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";

    public static final String COL_HAS_DEPOSIT = "has_deposit";

    public static final String COL_FIRST_WITHDRAW_CASH = "first_withdraw_cash";

    public static final String COL_IS_FIRST_WITHDRAW = "is_first_withdraw";

    public static final String COL_IS_SPLIT_ORDER = "is_split_order";

    public static final String COL_PARENT_ORDER_SN = "parent_order_sn";

    public static final String COL_NO_INVITE_REWARD = "no_invite_reward";

    public static final String COL_GOODS_CNT = "goods_cnt";

    public static final String COL_ORDER_STATE = "order_state";

    public static final String COL_SETTLEMENT_PARENT_ORDER_SN = "settlement_parent_order_sn";

    public static final String COL_IS_SURPLUS_ORDER = "is_surplus_order";

    public static final String COL_IS_CONSUME_MONEY = "is_consume_money";

    public static final String COL_IS_ADVANCE_SETTLE_ORDER = "is_advance_settle_order";

    public static final String COL_ACTIVE_IDENTITY = "active_identity";

    public static final String COL_IS_PUSH_SETTLE_TASK = "is_push_settle_task";

    public static final String COL_IS_ASSIST = "is_assist";

    public static final String COL_MAX_RATE = "max_rate";

    public static final String COL_MINI_RATE = "mini_rate";
}