package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Data;

@Data
@TableName(value = "order_taobao_jd_goods_commission")
public class OrderTaobaoJdGoodsCommission implements Serializable {
    /**
     * 订单类型 taobao:淘宝,jd:京东
     */
     @TableId(value = "type", type = IdType.INPUT)
    private String type;

    /**
     * 订单号
     */
     @TableId(value = "order_sn", type = IdType.INPUT)
    private String orderSn;

    /**
     * 子订单编号
     */
     @TableId(value = "sub_order_sn", type = IdType.INPUT)
    private String subOrderSn;

    /**
     * 父订单号
     */
    @TableField(value = "order_sn_parent")
    private String orderSnParent;

    /**
     * 是否是父订单
     */
    @TableField(value = "is_parent")
    private Integer isParent;

    /**
     * 商品id
     */
    @TableField(value = "goods_id")
    private String goodsId;

    /**
     * 商品数
     */
    @TableField(value = "goods_cnt")
    private Integer goodsCnt;

    /**
     * 标题
     */
    @TableField(value = "title")
    private String title;

    /**
     * 预估佣金
     */
    @TableField(value = "estimate_effect")
    private BigDecimal estimateEffect;

    /**
     * 实际结算佣金
     */
    @TableField(value = "commission_amount")
    private BigDecimal commissionAmount;

    /**
     * 0未付款 1付款 2成功 3结算 -3失效
     */
    @TableField(value = "order_state")
    private Integer orderState;

    /**
     * 订单创建时间
     */
    @TableField(value = "create_time")
    private LocalDateTime createTime;

    /**
     * 结算时间
     */
    @TableField(value = "settle_time")
    private LocalDateTime settleTime;

    /**
     * 用户下单时支付金额
     */
    @TableField(value = "order_amount")
    private BigDecimal orderAmount;

    /**
     * 用户实际支付金额
     */
    @TableField(value = "check_amount")
    private BigDecimal checkAmount;

    /**
     * 是否预付订金订单 1是0否
     */
    @TableField(value = "has_deposit")
    private Integer hasDeposit;

    /**
     * 是否新人专享
     */
    @TableField(value = "is_for_new")
    private Integer isForNew;

    /**
     * 如果新人专享有多条,此为排序,只按排序值为1的结算补贴
     */
    @TableField(value = "for_new_rank")
    private Integer forNewRank;

    /**
     * 呼呼新人专享补贴快照
     */
    @TableField(value = "huhu_subsidy_snapshot")
    private BigDecimal huhuSubsidySnapshot;

    /**
     * 广告位名称
     */
    @TableField(value = "pname")
    private String pname;

    /**
     * 不给合伙人奖励: 1不给 0给
     */
    @TableField(value = "no_invite_reward")
    private Integer noInviteReward;

    /**
     * 呼呼新人专享实际补贴
     */
    @TableField(value = "huhu_subsidy_actual")
    private BigDecimal huhuSubsidyActual;

    /**
     * 呼呼新人专享实际补贴
     */
    @TableField(value = "commission_snapshot")
    private BigDecimal commissionSnapshot;

    /**
     * 呼呼给用户结算的佣金
     */
    @TableField(value = "money")
    private BigDecimal money;

    /**
     * 淘宝/京东/天猫
     */
    @TableField(value = "order_type")
    private String orderType;

    /**
     * 是否有维权退款
     */
    @TableField(value = "has_refund")
    private Integer hasRefund;

    /**
     * 是否京东PLUS
     */
    @TableField(value = "is_jd_plus")
    private Integer isJdPlus;

    /**
     * 乘系数之前的结算佣金
     */
    @TableField(value = "all_money")
    private BigDecimal allMoney;

    /**
     * 维权退款扣回佣金
     */
    @TableField(value = "refund_amount")
    private BigDecimal refundAmount;

    /**
     * 呼呼返佣比例
     */
    @TableField(value = "huhu_commission_rate")
    private BigDecimal huhuCommissionRate;

    /**
     * 是否大淘客分享订单
     */
    @TableField(value = "is_share_order")
    private Integer isShareOrder;

    /**
     * 插入时间
     */
    @TableField(value = "insert_time")
    private LocalDateTime insertTime;

    /**
     * 新人专享到手价
     */
    @TableField(value = "to_get_price")
    private BigDecimal toGetPrice;

    /**
     * 用户角色: 10普通,20VIP,30超V
     */
    @TableField(value = "self_role")
    private Integer selfRole;

    /**
     * 累计更新次数
     */
    @TableField(value = "update_times")
    private Integer updateTimes;

    /**
     * 新人专享订单最多返给用户金额
     */
    @TableField(value = "huhu_subsidy_max")
    private BigDecimal huhuSubsidyMax;

    private static final long serialVersionUID = 1L;

    public static final String COL_ORDER_SN_PARENT = "order_sn_parent";

    public static final String COL_IS_PARENT = "is_parent";

    public static final String COL_GOODS_ID = "goods_id";

    public static final String COL_GOODS_CNT = "goods_cnt";

    public static final String COL_TITLE = "title";

    public static final String COL_ESTIMATE_EFFECT = "estimate_effect";

    public static final String COL_COMMISSION_AMOUNT = "commission_amount";

    public static final String COL_ORDER_STATE = "order_state";

    public static final String COL_CREATE_TIME = "create_time";

    public static final String COL_SETTLE_TIME = "settle_time";

    public static final String COL_ORDER_AMOUNT = "order_amount";

    public static final String COL_CHECK_AMOUNT = "check_amount";

    public static final String COL_HAS_DEPOSIT = "has_deposit";

    public static final String COL_IS_FOR_NEW = "is_for_new";

    public static final String COL_FOR_NEW_RANK = "for_new_rank";

    public static final String COL_HUHU_SUBSIDY_SNAPSHOT = "huhu_subsidy_snapshot";

    public static final String COL_PNAME = "pname";

    public static final String COL_NO_INVITE_REWARD = "no_invite_reward";

    public static final String COL_HUHU_SUBSIDY_ACTUAL = "huhu_subsidy_actual";

    public static final String COL_COMMISSION_SNAPSHOT = "commission_snapshot";

    public static final String COL_MONEY = "money";

    public static final String COL_ORDER_TYPE = "order_type";

    public static final String COL_HAS_REFUND = "has_refund";

    public static final String COL_IS_JD_PLUS = "is_jd_plus";

    public static final String COL_ALL_MONEY = "all_money";

    public static final String COL_REFUND_AMOUNT = "refund_amount";

    public static final String COL_HUHU_COMMISSION_RATE = "huhu_commission_rate";

    public static final String COL_IS_SHARE_ORDER = "is_share_order";

    public static final String COL_INSERT_TIME = "insert_time";

    public static final String COL_TO_GET_PRICE = "to_get_price";

    public static final String COL_SELF_ROLE = "self_role";

    public static final String COL_UPDATE_TIMES = "update_times";

    public static final String COL_HUHU_SUBSIDY_MAX = "huhu_subsidy_max";
}