package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Data;

@Data
@TableName(value = "agent_salary")
public class AgentSalary implements Serializable {
     @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 代理商用户ID
     */
    @TableField(value = "user_id")
    private Integer userId;

    /**
     * 代理商ID
     */
    @TableField(value = "agent_id")
    private Integer agentId;

    /**
     * 月份
     */
    @TableField(value = "month")
    private String month;

    /**
     * 总金额
     */
    @TableField(value = "balance")
    private BigDecimal balance;

    /**
     * 开卡奖励金额
     */
    @TableField(value = "opencard_balance")
    private BigDecimal opencardBalance;

    /**
     * 充值奖励金额
     */
    @TableField(value = "recharge_balance")
    private BigDecimal rechargeBalance;

    /**
     * 购买VIP会员奖励金额
     */
    @TableField(value = "upgrade_balance")
    private BigDecimal upgradeBalance;

    /**
     * 购买超级VIP会员奖励金额
     */
    @TableField(value = "upgrade_super_balance")
    private BigDecimal upgradeSuperBalance;

    /**
     * 缴税金额
     */
    @TableField(value = "tax_balance")
    private BigDecimal taxBalance;

    /**
     * 姓名或许公司名称
     */
    @TableField(value = "bank_account")
    private String bankAccount;

    /**
     * 卡号
     */
    @TableField(value = "bank_card_number")
    private String bankCardNumber;

    /**
     * 银行名称
     */
    @TableField(value = "bank_name")
    private String bankName;

    /**
     * 支行名称
     */
    @TableField(value = "branch_name")
    private String branchName;

    /**
     * 关联的银行绑定id
     */
    @TableField(value = "reference_id")
    private Long referenceId;

    /**
     * 状态 10待提现 20已提现
     */
    @TableField(value = "status")
    private Integer status;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private LocalDateTime createTime;

    /**
     * 提现时间
     */
    @TableField(value = "modify_time")
    private LocalDateTime modifyTime;

    @TableField(value = "created_at")
    private Long createdAt;

    @TableField(value = "updated_at")
    private Long updatedAt;

    @TableField(value = "deleted_at")
    private Long deletedAt;

    private static final long serialVersionUID = 1L;

    public static final String COL_USER_ID = "user_id";

    public static final String COL_AGENT_ID = "agent_id";

    public static final String COL_MONTH = "month";

    public static final String COL_BALANCE = "balance";

    public static final String COL_OPENCARD_BALANCE = "opencard_balance";

    public static final String COL_RECHARGE_BALANCE = "recharge_balance";

    public static final String COL_UPGRADE_BALANCE = "upgrade_balance";

    public static final String COL_UPGRADE_SUPER_BALANCE = "upgrade_super_balance";

    public static final String COL_TAX_BALANCE = "tax_balance";

    public static final String COL_BANK_ACCOUNT = "bank_account";

    public static final String COL_BANK_CARD_NUMBER = "bank_card_number";

    public static final String COL_BANK_NAME = "bank_name";

    public static final String COL_BRANCH_NAME = "branch_name";

    public static final String COL_REFERENCE_ID = "reference_id";

    public static final String COL_STATUS = "status";

    public static final String COL_CREATE_TIME = "create_time";

    public static final String COL_MODIFY_TIME = "modify_time";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";

    public static final String COL_DELETED_AT = "deleted_at";
}