package com.lanren.huhu.partner.dao;

import org.apache.ibatis.annotations.Param;

/**
 * @author chen
 * @title: UserAgentSqlProvider
 * @projectName partner
 * @description: 提供动态sql
 * @package com.lanren.huhu.partner.dao
 * @date 2019-07-03 16:29
 */
public class UserAgentSqlProvider {
    public String getParentAgent(@Param("agentId") Integer agentId, @Param("parentColumnName") String parentColumnName) {
        return "SELECT b.* " +
                "FROM user_agent a " +
                "JOIN user_agent b on a." + parentColumnName + "=b.agent_id " +
                "WHERE a.agent_id=#{agentId} and b.agent_level<=4";
    }
    public String getChildListByUserId(@Param("userId") Integer userId, @Param("parentColumnName") String parentColumnName) {
        return "SELECT a.* " +
                "FROM user_agent a " +
                "JOIN user_agent b on a." + parentColumnName + "=b.agent_id " +
                "WHERE b.user_id=#{userId} and b.agent_level<=4";
    }
}
