package com.lanren.huhu.partner.controller;

import com.lanren.huhu.partner.manager.UserManager;
import com.lanren.huhu.partner.model.User;
import com.lanren.huhu.partner.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.time.LocalDateTime;

/**
 * @author chen
 */
@RestController
@EnableAsync
@RequestMapping("/v1/user")
public class UserController {
    private static Logger logger = LoggerFactory.getLogger(UserController.class);

    @Autowired
    private UserManager userManager;

    @RequestMapping(value = "/relation", method = RequestMethod.POST)
    public Result<User> getRelation(@RequestBody @Valid User user, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("getRelation userId:{},header:{},time:{}", user.getUserId(), headers.keySet().toArray(), LocalDateTime.now());
        }
        return userManager.getRelationByUserId(user.getUserId());
    }

    @RequestMapping(value = "/relation/delete", method = RequestMethod.POST)
    public Result<String> deletrRelation(@RequestBody @Valid User user, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("deletrRelation userId:{},header:{},time:{}", user.getUserId(), headers.keySet().toArray(), LocalDateTime.now());
        }
        return userManager.deleteRalationByUserId(user.getUserId());
    }

    @RequestMapping(value = "/relation/change", method = RequestMethod.POST)
    public Result<String> changeRelation(@RequestBody @Valid User user, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("purgeRelation userId:{},header:{},time:{}", user.getUserId(), headers.keySet().toArray(), LocalDateTime.now());
        }
        userManager.purgeRelation(user.getUserId());
        logger.info("============>" + Thread.currentThread().getName());
        Result<String> result = new Result<String>();
        result.setData("异步,正在执行刷新......");
        return result;
    }

    @RequestMapping(value = "/update/relation/{from}/{to}/{type}" ,method = RequestMethod.GET)
    public Result<String> updateRelation(@PathVariable("from") String from, @PathVariable("to") String to, @PathVariable("type") int type) {
        userManager.updateRelation(from, to, type);
        logger.info("============>" + Thread.currentThread().getName());
        logger.info("============>from{}, to{}, type{}", from, to, type );
        Result<String> result = new Result<String>();
        result.setData("异步,正在执行更新新......");
        return result;
    }
}
