package com.lanren.huhu.partner.controller;

import com.lanren.huhu.partner.manager.AgentManager;
import com.lanren.huhu.partner.model.Agent;
import com.lanren.huhu.partner.model.AgentResponse;
import com.lanren.huhu.partner.model.ParentAgent;
import com.lanren.huhu.partner.result.Result;
import com.lanren.huhu.partner.schedule.AgentDailyExpandTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.time.LocalDateTime;
import java.util.ArrayList;

/**
 * @author chen
 */
@RestController
@RequestMapping("/v1/agent")
public class AgentController {
    private static Logger logger = LoggerFactory.getLogger(AgentController.class);

    @Autowired
    AgentManager agentManager;
    @Autowired
    AgentDailyExpandTask agentDailyExpandTask;

    @RequestMapping(value = "/level", method = RequestMethod.POST)
    public Result<AgentResponse> getAgentLevel(@RequestBody @Valid Agent agent, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("AgentController getLevel agentId:{},header:{},time:{}", agent.getAgentId(), headers.keySet().toArray(), LocalDateTime.now());
        }
        return agentManager.getAgentLevel(agent.getAgentId());
    }

    @RequestMapping(value = "/reward/push", method = RequestMethod.POST)
    public Result<String> pushReward(@RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("AgentController pushReward, header:{},time:{}", headers.keySet().toArray(), LocalDateTime.now());
        }
        return agentManager.pushReward();
    }
    @RequestMapping(value = "/hierarchy/parent", method = RequestMethod.POST)
    public Result<ArrayList<ParentAgent>> getHierarchyParentList(@RequestBody @Valid Agent agent, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("AgentController getHierarchyParentList, header:{},time:{}", headers.keySet().toArray(), LocalDateTime.now());
        }
        return agentManager.getHierarchyParentList(agent.getAgentId());
    }
    @RequestMapping(value = "/pingtui/parent", method = RequestMethod.POST)
    public Result<ArrayList<ParentAgent>> getPingtuiParentList(@RequestBody @Valid Agent agent, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("AgentController getPingtuiParentList, header:{},time:{}", headers.keySet().toArray(), LocalDateTime.now());
        }
        return agentManager.getPingtuiParentList(agent.getAgentId());
    }
    @RequestMapping(value = "/expand/{dat}", method = RequestMethod.GET)
    public Result<String> updateOneDayExpand(@PathVariable("dat") String dat) {
        agentDailyExpandTask.runSummary(dat);
        logger.info("============>" + Thread.currentThread().getName());
        Result<String> result = new Result<String>();
        result.setData("异步,正在执行刷新......");
        return result;
    }
}
