package com.lanren.huhu.partner.service;

import java.util.List;

import com.lanren.huhu.partner.dao.PartnerAccountMapper;
import com.lanren.huhu.partner.domain.UserAgent;
import com.baomidou.mybatisplus.extension.service.IService;
import org.springframework.beans.factory.annotation.Autowired;

public interface UserAgentService extends IService<UserAgent>{

    int updateBatch(List<UserAgent> list);

    int batchInsert(List<UserAgent> list);

    int insertOrUpdate(UserAgent record);

    int insertOrUpdateSelective(UserAgent record);

    /***
     * 根据代理商id查询账户信息
     * @param agentId
     * @return
     */
    UserAgent getOneByAgentId(Integer agentId);

    /***
     * 根据用户id查询账户信息
     * @param userId
     * @return
     */
    UserAgent getOneByUserId(Integer userId);

    /**
     * 根据代理商id找到上级代理商
     */
    UserAgent getParentAgent(Integer agentId);
}
