package com.lanren.huhu.partner.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.lanren.huhu.partner.domain.PartnerAccount;

import java.util.List;

/**
 * @author houseme
 */
public interface PartnerAccountService extends IService<PartnerAccount> {


    /**
     * 批量更新
     *
     * @param list
     * @return
     */
    int updateBatch(List<PartnerAccount> list);

    /**
     * 批量写入
     *
     * @param list
     * @return
     */
    int batchInsert(List<PartnerAccount> list);

    /**
     * 更新或新增
     *
     * @param partnerAccount
     * @return
     */
    int insertOrUpdate(PartnerAccount partnerAccount);

    /**
     * 选择性写入
     *
     * @param partnerAccount
     * @return
     */
    int insertOrUpdateSelective(PartnerAccount partnerAccount);

    /***
     * 根据用户id查询账户信息
     * @param userId
     * @return
     */
    PartnerAccount getOneByUserId(Integer userId);

    /**
     * @description: TODO
     * @param userId
     * @return PartnerAccount
     * @throws
     * @author chen
     * @date 2019-06-26 20:13
     */
    PartnerAccount getParentPartner(Integer userId);
}
