package com.lanren.huhu.partner.model;

import com.lanren.huhu.partner.controller.UserController;
import com.lanren.huhu.partner.model.base.BaseModel;
import lombok.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;

/**
 * @author chen
 * @title: User
 * @projectName partner
 * @description: 用户输入/输出
 * @package com.lanren.huhu.partner.model
 * @date 2019-06-2619:56
 */
@Data
public class User extends BaseModel {
    private static Logger logger = LoggerFactory.getLogger(User.class);

    @NotNull(message = "userId 不能为空")
    @Min(value = 1, message = "userId 需要大于0")
    private int userId;

    private ArrayList<ParentPartner> partnerList;
    private ArrayList<ParentAgent> agentList;

    /**
     * 坑哦!!!!
     * 这里不能添加任何的构造方法
     * 不然autotype哪里会报错
     * com.alibaba.fastjson.parser.ParserConfig.checkAutoType(ParserConfig.java:1180)
     * if (beanInfo.creatorConstructor != null && autoTypeSupport) {
     *     throw new JSONException("autoType is not support. " + typeName);
     *  }
     * 问题出在第一个判定 如果自己写了构造方法
     */
//    public User(@NotNull(message = "userId 不能为空") @Min(value = 1, message = "userId 需要大于0") int userId) {
//        this.userId = userId;
//        logger.info("do set name");
//        this.name = "testName";
//    }

    @Override
    public String toString() {
        return "User{" +
                "userId=" + userId +
                ", partnerList=" + partnerList +
                ", agentList=" + agentList +
                '}';
    }
}
