package com.lanren.huhu.partner.controller;

import com.lanren.huhu.partner.manager.UserManager;
import com.lanren.huhu.partner.model.User;
import com.lanren.huhu.partner.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.time.LocalDateTime;

/**
 * @author chen
 */
@RestController
@RequestMapping("/v1/user")
public class UserController {
    private static Logger logger = LoggerFactory.getLogger(UserController.class);

    @Autowired
    private UserManager userManager;

    @RequestMapping(value = "/relation", method = RequestMethod.POST)
    public Result<User> getRelation(@RequestBody @Valid User user, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("getRelation userId:{ },header:{},time:{}", user.getUserId(), headers.keySet().toArray(), LocalDateTime.now());
        }
        User resutrnUser = userManager.getRelationByUserId(user.getUserId());
        Result<User> result = new Result<User>();
        result.setData(resutrnUser);
        return result;
    }

    @RequestMapping(value = "/relation/delete", method = RequestMethod.POST)
    public Result<String> deletrRelation(@RequestBody @Valid User user, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("deletrRelation userId:{ },header:{},time:{}", user.getUserId(), headers.keySet().toArray(), LocalDateTime.now());
        }
        userManager.deleteRalationByUserId(user.getUserId());
        Result<String> result = new Result<String>();
        result.setData("删除成功");
        return result;
    }
}
