package com.lanren.huhu.partner.controller;

import com.lanren.huhu.partner.manager.PartnerAccountManager;
import com.lanren.huhu.partner.model.Partner;
import com.lanren.huhu.partner.model.PartnerRsp;
import com.lanren.huhu.partner.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.time.LocalDateTime;


/**
 * @Author houseme
 * @Date 2019-06-26 11:00
 * @Project partner
 * @Package com.lanren.huhu.partner.controller
 * @File: PartnerController
 */
@RestController
@RequestMapping("/v1/partner")
public class PartnerController {
    private static Logger logger = LoggerFactory.getLogger(PartnerController.class);

    @Autowired
    private PartnerAccountManager partnerAccountManager;

    @RequestMapping(value = "/level", method = RequestMethod.POST)
    public Result<PartnerRsp> getPartnerLevel(@RequestBody @Valid Partner partner, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("getPartnerLevel userId:{ },header:{},time:{}", partner.getUserId(), headers.keySet().toArray(), LocalDateTime.now());
        }
        return partnerAccountManager.getPartnerLevel(partner.getUserId());
    }
}
