package com.lanren.huhu.partner.controller;

import com.lanren.huhu.partner.manager.UserAgentManager;
import com.lanren.huhu.partner.model.Agent;
import com.lanren.huhu.partner.model.AgentRsp;
import com.lanren.huhu.partner.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.time.LocalDateTime;

/**
 * @author chen
 */
@RestController
@RequestMapping("/v1/agent")
public class AgentController {
    private static Logger logger = LoggerFactory.getLogger(AgentController.class);

    @Autowired
    UserAgentManager userAgentManager;

    @RequestMapping(value = "/level", method = RequestMethod.POST)
    public Result<AgentRsp> getAgentLevel(@RequestBody @Valid Agent agent, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("getLevel agentId:{},header:{},time:{}", agent.getAgentId(), headers.keySet().toArray(), LocalDateTime.now());
        }
        return userAgentManager.getAgentLevel(agent.getAgentId());
    }
}
