package com.lanren.huhu.partner.util;


import org.springframework.util.StringUtils;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * @author houseme
 */
public class MessageUtil {

    private static Map<Integer, String> cache = new HashMap<Integer, String>();

    public static void put(int code, String msg) {
        if (cache.containsKey(code)) {
            return;
        }
        cache.put(code, msg);
    }

    public static void putAll(Map<Integer, String> map) {
        cache.putAll(map);
    }

    public static String getMsg(int code) {
        return getMsg(code, "");
    }

    public static String getMsg(int code, String defaultValue) {
        return getMsg(code, null, defaultValue);
    }

    public static String getMsg(int code, String[] params, String defaultValue) {
        return cache.containsKey(code) ? handleParam(cache.get(code), params) : defaultValue;
    }

    protected static String handleParam(String msg, String[] params) {
        if (params == null || params.length == 0) {
            return msg;
        }
        if (StringUtils.isEmpty(msg)) {
            return "";
        }
        MessageFormat mf = new MessageFormat(msg);
        mf.setLocale(Locale.CHINESE);
        return mf.format(params);
    }
}
