package com.lanren.huhu.partner.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.lanren.huhu.partner.domain.AgentReward;
import com.lanren.huhu.partner.model.AgentSettle;

import java.util.List;

/**
 * @author chen
 * @title: ${NAME}
 * @projectName partner
 * @description: 代理商奖励明细
 * @package ${PACKAGE_NAME}
 * @date 2019-06-29 18:49
 */
public interface AgentRewardService extends IService<AgentReward> {


    int updateBatch(List<AgentReward> list);

    int batchInsert(List<AgentReward> list);

    int insertOrUpdate(AgentReward record);

    int insertOrUpdateSelective(AgentReward record);

    List<AgentReward> getListByRefId(String refId);

    List<AgentReward> getListBySubOrderSn(String orderType, String orderSn, String subOrderSn);

    int insertOne(AgentReward record);

    AgentSettle selectAgentSettleByTsAndAgentId(long beginTs, long endTs, Integer agentId);

    IPage<AgentReward> selectOrderRewardPageByTs(Page<AgentReward> page, long beginTs, long endTs);

    IPage<AgentReward> selectOrderRewardPageByTsAndAgentId(Page<AgentReward> page, long beginTs, long endTs, int agentId);

    int updateRewardStatusByUidAndTs(int agentId, long beginTs, long endTs);

    IPage<AgentSettle> selectAgentSettlePageByTs(Page<AgentSettle> page, long beginTs, long endTs);
}






