package com.lanren.huhu.partner.result;

import com.alibaba.fastjson.annotation.JSONField;
import com.lanren.huhu.partner.model.base.BaseModel;
import com.lanren.huhu.partner.util.MessageUtil;

/**
 * 封装Controller返回对象
 *
 * @author houseme
 * @version 1.0
 * @date 2016年7月18日 上午10:27:00
 */
public class Result<T> extends BaseModel {
    @JSONField(name="errorCode")
    private int code;
    private String message;
    private T data;
    private Long time;

    public Result() {
        this.code = 0;
        this.message = MessageUtil.getMsg(code);
        this.time = System.currentTimeMillis();
    }

    public Result(T data) {
        this.code = 0;
        this.message = MessageUtil.getMsg(code);
        this.data = data;
        this.time = System.currentTimeMillis();
    }

    public Result(int code) {
        this.code = code;
        this.message = MessageUtil.getMsg(code);
        this.time = System.currentTimeMillis();
    }

    public Result(int code, String msg) {
        this.code = code;
        this.message = msg;
        this.time = System.currentTimeMillis();
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
        this.message = MessageUtil.getMsg(code);
        this.time = System.currentTimeMillis();
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Long getTime() {
        return time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    @Override
    public String toString() {
        return "Result{" +
                "code=" + code +
                ", message='" + message + '\'' +
                ", data=" + data +
                ", time=" + time +
                '}';
    }

}
