package com.lanren.huhu.partner.model;

import com.lanren.huhu.partner.model.base.BaseModel;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author chen
 * @title: PartnerSettle
 * @projectName partner
 * @description: 合伙人结算数据 sumOrderCommission 和 sumRedpack 的值 是扣除techCharge之后的值
 * @package com.lanren.huhu.partner.model
 * @date 2019-07-18 15:59
 */
@Data
public class PartnerSettle extends BaseModel {
    private int userId;
    /**
     * 扣除技术服务费后的购物奖励 包含 平台额外奖励部分
     */
    private BigDecimal sumOrderCommission;
    /**
     * 扣除技术服务费后的在线充值奖励 包含 平台额外奖励部分
     */
    private BigDecimal sumRedpack;
    /**
     * 其他全部奖励
     */
    private BigDecimal sumOthers;
    private BigDecimal techChargeRedpack;
    private BigDecimal techChargeOrder;
    private BigDecimal wxIncome;
    private BigDecimal wxTax;
    private BigDecimal bankIncome;
    private BigDecimal bankTax;
    /**
     * 在线充值
     */
    private BigDecimal cash;
    private int num;
    /**
     * 升级奖励
     */
    private BigDecimal upCash;
    private int upNum;
    /**
     * 邀请奖励
     */
    private BigDecimal icash;
    private int inum;
    /**
     * 下单奖励
     */
    private BigDecimal pcash;
    private int pnum;
    /**
     * 购物奖励: 淘宝客/京东联盟 佣金
     */
    private BigDecimal scash;
    private int snum;
    /**
     * 平台额外奖励
     */
    private BigDecimal rcash;
}
