package com.lanren.huhu.partner.manager;

import com.lanren.huhu.partner.domain.PartnerAccount;
import com.lanren.huhu.partner.model.PartnerResponse;
import com.lanren.huhu.partner.result.Result;
import com.lanren.huhu.partner.schedule.PartnerSettleTask;
import com.lanren.huhu.partner.service.PartnerAccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @author houseme
 * @date 2019-06-26 10:56
 * @Project partner
 * @Package com.lanren.huhu.partner.manager
 * @File: PartnerAccountManager
 */
@Component
public class PartnerManager {
    private static Logger logger = LoggerFactory.getLogger(PartnerManager.class);

    @Autowired
    private PartnerAccountService partnerAccountService;
    @Autowired
    private PartnerSettleTask partnerSettleTask;

    /***
     * 获取合伙人账户信息
     * @param userId
     * @return
     */
    public Result<PartnerAccount> findByUserId(Integer userId) {
        Result<PartnerAccount> result = new Result<>();
        if (logger.isDebugEnabled()) {
            logger.info("PartnerAccountManager findByUserId userId:{},time:{}", userId, LocalDateTime.now());
        }
        PartnerAccount partnerAccount = partnerAccountService.getOneByUserId(userId);
        result.setData(partnerAccount);
        return result;
    }

    /***
     * 获取合伙人等级 10 普通, 20 高级, 30 超级
     * @param userId
     * @return
     */
    public Result<PartnerResponse> getPartnerLevel(Integer userId) {
        if (logger.isDebugEnabled()) {
            logger.info("PartnerAccountManager getPartnerLevel userId:{},time:{}", userId, LocalDateTime.now());
        }
        Result<PartnerResponse> result = new Result<>();
        PartnerAccount partnerAccount = partnerAccountService.getOneByUserId(userId);
        if (null != partnerAccount) {
            int partnerLevel;
            if (partnerAccount.getIsSuperPartner() == 1) {
                partnerLevel = 30;
            } else {
                partnerLevel = partnerAccount.getPartnerLevel();
            }
            result.setData(new PartnerResponse(partnerLevel));
        } else {
            result.setCode(601);
        }
        return result;
    }

    public Result<String> doFinanceSettle(int userId) {
        Result<String> result = new Result<>();
        if (partnerSettleTask.doOneUserSettle(userId)) {
            result.setCode(0);
        } else {
            result.setCode(500);
        }
        return result;
    }

//    public Result<String> runSummary(String dateStr, int userId) {
//        Result<String> result = new Result<>();
//        if (partnerSettleTask.runSummary(dateStr, userId)) {
//            result.setCode(0);
//        } else {
//            result.setCode(500);
//        }
//        return result;
//    }
}
