package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Data;

@Data
@TableName(value = "order_taobao_jd_commission")
public class OrderTaobaoJdCommission implements Serializable {
    /**
     * 订单类型 taobao:淘宝,jd:京东
     */
    @TableId(value = "type", type = IdType.INPUT)
    private String type;

    /**
     * 订单号
     */
    @TableId(value = "order_sn", type = IdType.INPUT)
    private String orderSn;

    /**
     * 父订单号
     */
    @TableField(value = "order_sn_parent")
    private String orderSnParent;

    /**
     * 是否是父订单
     */
    @TableField(value = "is_parent")
    private Integer isParent;

    /**
     * 标题
     */
    @TableField(value = "title")
    private String title;

    /**
     * 预估佣金
     */
    @TableField(value = "estimate_effect")
    private BigDecimal estimateEffect;

    /**
     * 实际结算佣金
     */
    @TableField(value = "commission_amount")
    private BigDecimal commissionAmount;

    /**
     * 维权退款返还佣金
     */
    @TableField(value = "refund_amount")
    private BigDecimal refundAmount;

    /**
     * 变现金额
     */
    @TableField(value = "money")
    private BigDecimal money;

    /**
     * 乘系数之前的给用户返佣金额
     */
    @TableField(value = "all_money")
    private BigDecimal allMoney;

    /**
     * 0未付款 1付款 3 结算 -3失效
     */
    @TableField(value = "status")
    private Integer status;

    /**
     * 订单创建时间
     */
    @TableField(value = "create_time")
    private LocalDateTime createTime;

    /**
     * 结算时间
     */
    @TableField(value = "settle_time")
    private LocalDateTime settleTime;

    /**
     * 倒计时最后时间
     */
    @TableField(value = "last_time")
    private LocalDateTime lastTime;

    /**
     * 用户实际支付金额
     */
    @TableField(value = "amount")
    private BigDecimal amount;

    @TableField(value = "created_at")
    private Integer createdAt;

    @TableField(value = "updated_at")
    private Integer updatedAt;

    @TableField(value = "deleted_at")
    private Integer deletedAt;

    @TableField(value = "user_id")
    private Integer userId;

    /**
     * 100 待激活 200 待结算 300 已结算
     */
    @TableField(value = "active_state")
    private Integer activeState;

    @TableField(value = "post_time")
    private LocalDateTime postTime;

    @TableField(value = "active_time")
    private LocalDateTime activeTime;

    /**
     * 广告位名称
     */
    @TableField(value = "pname")
    private String pname;

    /**
     * 是否预付订金订单 1是0否
     */
    @TableField(value = "has_deposit")
    private Integer hasDeposit;

    /**
     * 已激活用户显示当前佣金, 新用户显示预估佣金
     */
    @TableField(value = "commission_snapshot")
    private BigDecimal commissionSnapshot;

    /**
     * 是否是新人专享
     */
    @TableField(value = "is_for_new")
    private Integer isForNew;

    /**
     * 呼呼补贴金额快照
     */
    @TableField(value = "huhu_subsidy_snapshot")
    private BigDecimal huhuSubsidySnapshot;

    /**
     * 呼呼补贴金额实际
     */
    @TableField(value = "huhu_subsidy_actual")
    private BigDecimal huhuSubsidyActual;

    /**
     * 不给呼呼邀请奖励: 1不给 0给
     */
    @TableField(value = "no_invite_reward")
    private Integer noInviteReward;

    /**
     * 商品购买数量
     */
    @TableField(value = "goods_cnt")
    private Integer goodsCnt;

    /**
     * 呼呼返佣比例
     */
    @TableField(value = "huhu_commission_rate")
    private BigDecimal huhuCommissionRate;

    @TableField(value = "insert_time")
    private LocalDateTime insertTime;

    /**
     * 新人专享订单最多返给用户金额
     */
    @TableField(value = "huhu_subsidy_max")
    private BigDecimal huhuSubsidyMax;

    private static final long serialVersionUID = 1L;

    public static final String COL_ORDER_SN_PARENT = "order_sn_parent";

    public static final String COL_IS_PARENT = "is_parent";

    public static final String COL_TITLE = "title";

    public static final String COL_ESTIMATE_EFFECT = "estimate_effect";

    public static final String COL_COMMISSION_AMOUNT = "commission_amount";

    public static final String COL_REFUND_AMOUNT = "refund_amount";

    public static final String COL_MONEY = "money";

    public static final String COL_ALL_MONEY = "all_money";

    public static final String COL_STATUS = "status";

    public static final String COL_CREATE_TIME = "create_time";

    public static final String COL_SETTLE_TIME = "settle_time";

    public static final String COL_LAST_TIME = "last_time";

    public static final String COL_AMOUNT = "amount";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";

    public static final String COL_DELETED_AT = "deleted_at";

    public static final String COL_USER_ID = "user_id";

    public static final String COL_ACTIVE_STATE = "active_state";

    public static final String COL_POST_TIME = "post_time";

    public static final String COL_ACTIVE_TIME = "active_time";

    public static final String COL_PNAME = "pname";

    public static final String COL_HAS_DEPOSIT = "has_deposit";

    public static final String COL_COMMISSION_SNAPSHOT = "commission_snapshot";

    public static final String COL_IS_FOR_NEW = "is_for_new";

    public static final String COL_HUHU_SUBSIDY_SNAPSHOT = "huhu_subsidy_snapshot";

    public static final String COL_HUHU_SUBSIDY_ACTUAL = "huhu_subsidy_actual";

    public static final String COL_NO_INVITE_REWARD = "no_invite_reward";

    public static final String COL_GOODS_CNT = "goods_cnt";

    public static final String COL_HUHU_COMMISSION_RATE = "huhu_commission_rate";

    public static final String COL_INSERT_TIME = "insert_time";

    public static final String COL_HUHU_SUBSIDY_MAX = "huhu_subsidy_max";
}