package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

@Data
@TableName(value = "new_recruits_exclusive_log")
public class NewRecruitsExclusiveLog implements Serializable {
    /**
     * 主键
     */
     @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 1：签到、2：呼呼
     */
    @TableField(value = "app_id")
    private Integer appId;

    /**
     * 商品id
     */
    @TableField(value = "union_id")
    private String unionId;

    /**
     * 到手价
     */
    @TableField(value = "to_get_price")
    private BigDecimal toGetPrice;

    /**
     * 开始时间
     */
    @TableField(value = "start_time")
    private Long startTime;

    /**
     * 结束时间
     */
    @TableField(value = "end_time")
    private Long endTime;

    /**
     * 创建时间
     */
    @TableField(value = "created_at")
    private Long createdAt;

    /**
     * 修改时间
     */
    @TableField(value = "updated_at")
    private Long updatedAt;

    /**
     * 最高补贴价
     */
    @TableField(value = "max_subsidy_price")
    private BigDecimal maxSubsidyPrice;

    /**
     * 平台价
     */
    @TableField(value = "final_price")
    private BigDecimal finalPrice;

    /**
     * 佣金比例
     */
    @TableField(value = "commission_rate")
    private BigDecimal commissionRate;

    /**
     * 优惠券价格
     */
    @TableField(value = "coupon_amout")
    private BigDecimal couponAmout;

    private static final long serialVersionUID = 1L;

    public static final String COL_APP_ID = "app_id";

    public static final String COL_UNION_ID = "union_id";

    public static final String COL_TO_GET_PRICE = "to_get_price";

    public static final String COL_START_TIME = "start_time";

    public static final String COL_END_TIME = "end_time";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";

    public static final String COL_MAX_SUBSIDY_PRICE = "max_subsidy_price";

    public static final String COL_FINAL_PRICE = "final_price";

    public static final String COL_COMMISSION_RATE = "commission_rate";

    public static final String COL_COUPON_AMOUT = "coupon_amout";
}