package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import lombok.Data;

@Data
@TableName(value = "agent_revoke_records")
public class AgentRevokeRecords implements Serializable {
    /**
     * 主键id
     */
     @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 订单id
     */
    @TableField(value = "order_id")
    private String orderId;

    /**
     * 用户id(被邀请者的用户id)
     */
    @TableField(value = "user_id")
    private Long userId;

    /**
     * 回收的关联id
     */
    @TableField(value = "ref_id")
    private String refId;

    /**
     * 回收类型:100 邀请奖励的回收,120分享赚奖励的回收
     */
    @TableField(value = "revoke_type")
    private Integer revokeType;

    /**
     * 100 未处理 200处理成功
     */
    @TableField(value = "state")
    private Integer state;

    /**
     * 创建时间
     */
    @TableField(value = "created_at")
    private Long createdAt;

    /**
     * 更新时间
     */
    @TableField(value = "updated_at")
    private Long updatedAt;

    /**
     * 订单类型
     */
    @TableField(value = "order_type")
    private String orderType;

    /**
     * 订单号
     */
    @TableField(value = "order_sn")
    private String orderSn;

    /**
     * 子订单号
     */
    @TableField(value = "sub_order_sn")
    private String subOrderSn;

    private static final long serialVersionUID = 1L;

    public static final String COL_ORDER_ID = "order_id";

    public static final String COL_USER_ID = "user_id";

    public static final String COL_REF_ID = "ref_id";

    public static final String COL_REVOKE_TYPE = "revoke_type";

    public static final String COL_STATE = "state";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";

    public static final String COL_ORDER_TYPE = "order_type";

    public static final String COL_ORDER_SN = "order_sn";

    public static final String COL_SUB_ORDER_SN = "sub_order_sn";
}