package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Data;

@Data
@TableName(value = "agent_account")
public class AgentAccount implements Serializable {
     @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 关联用户id
     */
    @TableField(value = "user_id")
    private Integer userId;

    /**
     * 代理商id
     */
    @TableField(value = "agent_id")
    private Integer agentId;

    /**
     * 账户类型 10开头现金账户 其他带添加
     */
    @TableField(value = "account_type")
    private Integer accountType;

    /**
     * 账户总额
     */
    @TableField(value = "balance")
    private BigDecimal balance;

    /**
     * 冻结余额
     */
    @TableField(value = "frozen_balance")
    private BigDecimal frozenBalance;

    /**
     * 收入冻结
     */
    @TableField(value = "income_freeze")
    private BigDecimal incomeFreeze;

    /**
     * 出款冻结
     */
    @TableField(value = "pay_freeze")
    private BigDecimal payFreeze;

    /**
     * 可用余额
     */
    @TableField(value = "free_balance")
    private BigDecimal freeBalance;

    /**
     * 账户收入总额
     */
    @TableField(value = "income_balance")
    private BigDecimal incomeBalance;

    /**
     * 在线充值收入
     */
    @TableField(value = "recharge_income")
    private BigDecimal rechargeIncome;

    /**
     * 账户开卡收入
     */
    @TableField(value = "opencard_income")
    private BigDecimal opencardIncome;

    @TableField(value = "created_at")
    private Long createdAt;

    @TableField(value = "updated_at")
    private Long updatedAt;

    @TableField(value = "deleted_at")
    private Long deletedAt;

    /**
     * 提现总额
     */
    @TableField(value = "withdraw_balance")
    private BigDecimal withdrawBalance;

    /**
     * 消费总额
     */
    @TableField(value = "consume_balance")
    private BigDecimal consumeBalance;

    /**
     * 版本号
     */
    @TableField(value = "account_version")
    private Long accountVersion;

    /**
     * 状态 100默认正常 99禁用
     */
    @TableField(value = "account_status")
    private Integer accountStatus;

    /**
     * 创建时间戳
     */
    @TableField(value = "create_time")
    private LocalDateTime createTime;

    private static final long serialVersionUID = 1L;

    public static final String COL_USER_ID = "user_id";

    public static final String COL_AGENT_ID = "agent_id";

    public static final String COL_ACCOUNT_TYPE = "account_type";

    public static final String COL_BALANCE = "balance";

    public static final String COL_FROZEN_BALANCE = "frozen_balance";

    public static final String COL_INCOME_FREEZE = "income_freeze";

    public static final String COL_PAY_FREEZE = "pay_freeze";

    public static final String COL_FREE_BALANCE = "free_balance";

    public static final String COL_INCOME_BALANCE = "income_balance";

    public static final String COL_RECHARGE_INCOME = "recharge_income";

    public static final String COL_OPENCARD_INCOME = "opencard_income";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";

    public static final String COL_DELETED_AT = "deleted_at";

    public static final String COL_WITHDRAW_BALANCE = "withdraw_balance";

    public static final String COL_CONSUME_BALANCE = "consume_balance";

    public static final String COL_ACCOUNT_VERSION = "account_version";

    public static final String COL_ACCOUNT_STATUS = "account_status";

    public static final String COL_CREATE_TIME = "create_time";
}