package com.lanren.huhu.partner.dao;

import org.apache.ibatis.annotations.Param;

/**
 * @author chen
 * @title: UserAgentSqlProvider
 * @projectName partner
 * @description: 提供动态sql
 * @package com.lanren.huhu.partner.dao
 * @date 2019-07-03 16:29
 */
public class UserAgentSqlProvider {
    public String getParentAgent(@Param("agentId") Integer agentId, @Param("parentColumnName") String parentColumnName) {
        return "SELECT " +
                "b.agent_id, " +
                "b.user_id, " +
                "b.agent_name, " +
                "b.agent_phone, " +
                "b.agent_level, " +
                "b.node_agent_level_name, " +
                "b.parent_agent_id, " +
                "b.company, " +
                "b.parent_agent_list, " +
                "b.card_num, " +
                "b.card_activate_num, " +
                "b.commission_rate, " +
                "b.pid, " +
                "b.jd_pid, " +
                "b.identity, " +
                "b.account_type, " +
                "b.account, " +
                "b.have_card, " +
                "b.remark, " +
                "b.register_from, " +
                "b.invite_time, " +
                "b.active_time, " +
                "b.agent_state, " +
                "b.created_at, " +
                "b.updated_at, " +
                "b.deleted_at, " +
                "b.presenter_id, " +
                "b.present_time, " +
                "b.agent_level_one, " +
                "b.agent_level_two, " +
                "b.agent_level_three, " +
                "b.agent_level_four " +
                "FROM user_agent a " +
                "JOIN user_agent b on a." + parentColumnName + "=b.agent_id " +
                "WHERE a.agent_id=#{agentId} and b.agent_level<=4";
    }
    public String getChildListByUserId(@Param("userId") Integer userId, @Param("parentColumnName") String parentColumnName) {
        return "SELECT " +
                "a.agent_id, " +
                "a.user_id, " +
                "a.agent_name, " +
                "a.agent_phone, " +
                "a.agent_level, " +
                "a.node_agent_level_name, " +
                "a.parent_agent_id, " +
                "a.company, " +
                "a.parent_agent_list, " +
                "a.card_num, " +
                "a.card_activate_num, " +
                "a.commission_rate, " +
                "a.pid, " +
                "a.jd_pid, " +
                "a.identity, " +
                "a.account_type, " +
                "a.account, " +
                "a.have_card, " +
                "a.remark, " +
                "a.register_from, " +
                "a.invite_time, " +
                "a.active_time, " +
                "a.agent_state, " +
                "a.created_at, " +
                "a.updated_at, " +
                "a.deleted_at, " +
                "a.presenter_id, " +
                "a.present_time, " +
                "a.agent_level_one, " +
                "a.agent_level_two, " +
                "a.agent_level_three, " +
                "a.agent_level_four " +
                "FROM user_agent a " +
                "JOIN user_agent b on a." + parentColumnName + "=b.agent_id " +
                "WHERE b.user_id=#{userId} and b.agent_level<=4";
    }
}
