package com.lanren.huhu.partner.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.lanren.huhu.partner.domain.PartnerReward;
import com.lanren.huhu.partner.model.PartnerSettle;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface PartnerRewardMapper extends BaseMapper<PartnerReward> {
    int updateBatch(List<PartnerReward> list);

    int batchInsert(@Param("list") List<PartnerReward> list);

    int insertOrUpdate(PartnerReward record);

    int insertOrUpdateSelective(PartnerReward record);

    IPage<PartnerReward> selectOrderRewardPageByTs(Page<PartnerReward> page, @Param("beginTs") Long beginTs, @Param("endTs") Long endTs);

    IPage<PartnerReward> selectOrderRewardPageByTsAndUid(Page<PartnerReward> page, Long beginTs, Long endTs, Integer userId);

    IPage<PartnerSettle> selectPartnerSettlePageByTs(Page<PartnerSettle> page, Long beginTs, Long endTs);

    PartnerSettle selectPartnerSettleByTsAndUid(Long beginTs, Long endTs, Integer userId);

    int updateRewardStatusByUidAndTs(Integer userId, Long beginTs, Long endTs);
}