package com.lanren.huhu.partner.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.lanren.huhu.partner.domain.PartnerAccount;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface PartnerAccountMapper extends BaseMapper<PartnerAccount> {
    int updateBatch(List<PartnerAccount> list);

    int batchInsert(@Param("list") List<PartnerAccount> list);

    int insertOrUpdate(PartnerAccount record);

    int insertOrUpdateSelective(PartnerAccount record);

    /**
     * 按uid查找上级 PartnerAccount
     * @param userId
     * @return
     */
    @Select("SELECT " +
            "b.id, " +
            "b.user_id, " +
            "b.partner_level, " +
            "b.become_high_time, " +
            "b.is_super_partner, " +
            "b.become_super_time, " +
            "b.all_income, " +
            "b.curr_untaxed_income, " +
            "b.revoke_balance, " +
            "b.first_month_free, " +
            "b.income_after_tax, " +
            "b.wx_free_balance, " +
            "b.wx_withdrawn_balance, " +
            "b.bank_free_balance, " +
            "b.bank_withdrawn_balance, " +
            "b.frozen_withdraw_balance, " +
            "b.frozen_wx_withdraw_balance, " +
            "b.frozen_bank_withdraw_balance, " +
            "b.first_income_time, " +
            "b.created_at, " +
            "b.updated_at, " +
            "b.deleted_at, " +
            "b.create_time, " +
            "b.vip_deadline " +
            "FROM partner_invite_relation a " +
            "JOIN partner_account b on a.invite_user_id=b.user_id " +
            "WHERE a.user_id=#{userId}")
    PartnerAccount getParentByUserId(Integer userId);

    /**
     * 按uid查找下级 PartnerAccount
     */
    @Select("SELECT " +
            "b.id, " +
            "b.user_id, " +
            "b.partner_level, " +
            "b.become_high_time, " +
            "b.is_super_partner, " +
            "b.become_super_time, " +
            "b.all_income, " +
            "b.curr_untaxed_income, " +
            "b.revoke_balance, " +
            "b.first_month_free, " +
            "b.income_after_tax, " +
            "b.wx_free_balance, " +
            "b.wx_withdrawn_balance, " +
            "b.bank_free_balance, " +
            "b.bank_withdrawn_balance, " +
            "b.frozen_withdraw_balance, " +
            "b.frozen_wx_withdraw_balance, " +
            "b.frozen_bank_withdraw_balance, " +
            "b.first_income_time, " +
            "b.created_at, " +
            "b.updated_at, " +
            "b.deleted_at, " +
            "b.create_time, " +
            "b.vip_deadline " +
            "FROM partner_invite_relation a " +
            "JOIN partner_account b on a.user_id=b.user_id " +
            "WHERE a.invite_user_id=#{userId}")
    List<PartnerAccount> getChildListByUserId(Integer userId);

    PartnerAccount selectOneForUpdate(Integer userId);

    PartnerAccount getPartnerAccountByPhone(String phone);
}