package com.lanren.huhu.partner.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.lanren.huhu.partner.domain.AgentReward;
import com.lanren.huhu.partner.model.AgentSettle;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface AgentRewardMapper extends BaseMapper<AgentReward> {
    int updateBatch(List<AgentReward> list);

    int batchInsert(@Param("list") List<AgentReward> list);

    int insertOrUpdate(AgentReward record);

    int insertOrUpdateSelective(AgentReward record);

    IPage<AgentSettle> selectAgentSettlePageByTs(Page<AgentSettle> page, long beginTs, long endTs);

    AgentSettle selectAgentSettleByTsAndAgentId(long beginTs, long endTs, Integer agentId);

    IPage<AgentReward> selectOrderRewardPageByTs(Page<AgentReward> page, long beginTs, long endTs);

    IPage<AgentReward> selectOrderRewardPageByTsAndAgentId(Page<AgentReward> page, long beginTs, long endTs, int agentId);

    int updateRewardStatusByAgentIdAndTs(int agentId, long beginTs, long endTs);
}