package com.lanren.huhu.partner.constants;

import com.lanren.huhu.partner.util.DateUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author chen
 * @title: Constants
 * @projectName partner
 * @description: 常量
 * @package com.lanren.huhu.partner.constants
 * @date 2019-06-29 17:04
 */
public class Constants {
    public static final String AGENT_REWARD_QUEUE_KEY = "agent_reward_redis_city_key";
    /**
     * 代理商奖励类型
     */
    public static final int AGENT_REWARD_TYPE_YEAR_VIP = 710;
    public static final String AGENT_REWARD_TYPE_YEAR_VIP_REMARK = "推荐奖励-年VIP";
//    public static final int AGENT_REWARD_TYPE_HALF_YEAR_VIP = 720;
//    public static final String AGENT_REWARD_TYPE_HALF_YEAR_VIP_REMARK = "城市代理商所得的购买半年-VIP";
//    public static final int AGENT_REWARD_TYPE_SVIP = 730;
//    public static final String AGENT_REWARD_TYPE_SVIP_REMARK = "城市代理商所得的购买超级VIP收益";
    public static final int AGENT_REWARD_TYPE_REDPACK = 740;
    public static final String AGENT_REWARD_TYPE_REDPACK_REMARK = "推荐奖励-普通用户购买红包";
    public static final int AGENT_REWARD_TYPE_SELF_ORDER = 750;
    public static final String AGENT_REWARD_TYPE_SELF_ORDER_REMARK = "推荐奖励-自购省";
    public static final int AGENT_REWARD_TYPE_SHARE_ORDER = 760;
    public static final String AGENT_REWARD_TYPE_SHARE_ORDER_REMARK = "推荐奖励-分享赚";
    public static final int JD_OFFSET = 1000; //用于查找京东的平推奖励比例
    public static final int MT_OFFSET = 2000; //用于查找美团的平推奖励比例
    public static Map<Integer, Map<Integer, BigDecimal>> AGENT_RATE_MAP = new HashMap<Integer, Map<Integer, BigDecimal>>();
    public static Map<Integer, String> AGENT_REWARD_REMARK = new HashMap<Integer, String>();
    public static final int AGENT_LEVEL_1 = 1;
    public static final int AGENT_LEVEL_2 = 2;
    public static final int AGENT_LEVEL_3 = 3;
    public static final int AGENT_LEVEL_4 = 4;
    public static final String DISTRIBUTE_REDIS_LOCK_KEY = "huhu:partner:distribute:redis:key";
    public static final String PARENT_COLUMN_NAME_CENGJI = "parent_agent_id";
    public static final String PARENT_COLUMN_NAME_PINGTUI = "presenter_id";
    public static final String ORDER_TYPE_JD = "jd";
    public static final String ORDER_TYPE_MT = "mt";
    /**
     * 回扣类型
     */
    public static final int AGENT_REVOKE_TYPE_ACTIVATION = 100;
    public static final String AGENT_REVOKE_TYPE_ACTIVATION_REMARK = "下单激活奖励扣回";
    public static final int AGENT_REVOKE_TYPE_SELF_ORDER = 300;
    public static final String AGENT_REVOKE_TYPE_SELF_ORDER_REMARK = "自购省奖励扣回";
    public static final int AGENT_REVOKE_TYPE_SHARE_ORDER = 400;
    public static final String AGENT_REVOKE_TYPE_SHARE_ORDER_REMARK = "分享赚奖励扣回";
    public static Map<Integer, String> AGENT_REVOKE_TYPE_MAP = new HashMap<Integer, String>();
    /**
     * 回扣状态
     */
    public static final int REVOKE_STATE_PENDING = 100;
    public static final int REVOKE_STATE_DONE = 120;
    public static final int REVOKE_STATE_DO_NOTHING = 190;
    public static final int REVOKE_STATE_FAILED = 99;
    /**
     * 显示结算状态
     */
    public static final int SETTLE_STATE_ON_THE_WAY = 100;
    public static final int SETTLE_STATE_PRE = 200;
    public static final int SETTLE_STATE_DONE = 300;
//    public static final int SETTLE_STATE_FAILED = -300;
    /**
     * 财务结算状态
     */
    public static final int REWARD_STATUS_UNSETTLE = 100;
    public static final int REWARD_STATUS_SETTLE = 120;
//    public static final int REWARD_STATUS_FAILED = 99;
    /**
     * 最小奖励金额 小于此不写入
     */
    public static final BigDecimal MIN_REWARD = new BigDecimal("0.000001");

    /**
     * 代理商奖励push队列
     */
    public static final String AGENT_REWARD_PUSH_KEY = "agent:reward:queue";


    /**
     * 合伙人
     */
    public static final int PARTNER_REWARD_TYPE_REDPACK = 60;
    public static final String PARTNER_REWARD_TYPE_REDPACK_REMARK = "用户在线充值";
    public static final int PARTNER_REWARD_TYPE_VIP = 70;
    public static final String PARTNER_REWARD_TYPE_VIP_REMARK = "升高开户充值";
    public static final int PARTNER_REWARD_TYPE_INVITE = 80;
    public static final String PARTNER_REWARD_TYPE_INVITE_REMARK = "邀请奖励";
    public static final int PARTNER_REWARD_TYPE_ORDER_ACTIVE = 90;
    public static final String PARTNER_REWARD_TYPE_ORDER_ACTIVE_REMARK = "下单奖励";
    public static final int PARTNER_REWARD_TYPE_SVIP = 100;
    public static final String PARTNER_REWARD_TYPE_SVIP_REMARK = "购买超级VIP会员";
    public static final int PARTNER_REWARD_TYPE_PURCHASE = 110;
    public static final String PARTNER_REWARD_TYPE_PURCHASE_REMARK = "购物奖励";
    public static final int PARTNER_REWARD_TYPE_SHARE = 120;
    public static final String PARTNER_REWARD_TYPE_SHARE_REMARK = "分享赚奖励";
    /**
     * 订单状态
     */
    public static final int ORDER_STATE_FAILED = -3;
    public static final int ORDER_STATE_PAID = 1;
    public static final int ORDER_STATE_SETTLED = 3;
    /**
     * 阶梯算税
     */
    public static final BigDecimal TAX_STAGE_FREE_BASE = new BigDecimal("800");
    public static final BigDecimal TAX_STAGE_1 = new BigDecimal("4000");
    public static final BigDecimal TAX_STAGE_1_RATE1 = new BigDecimal("0.2"); //800-4000
    public static final BigDecimal TAX_STAGE_1_RATE2 = new BigDecimal("0.76");
    public static final BigDecimal TAX_STAGE_WX_MAX = new BigDecimal("17076.5"); //4000-17076.5
    public static final BigDecimal TAX_STAGE_WX_MAX_RATE1 = new BigDecimal("0.8"); //
    public static final BigDecimal TAX_STAGE_WX_MAX_RATE2 = new BigDecimal("0.2"); //
    public static final BigDecimal TAX_STAGE_WX_MAX_RATE3 = new BigDecimal("0.76"); //
    public static final BigDecimal BANK_RATE = new BigDecimal("0.1");
    /**
     * 合伙人变更记录
     */
    public static final int PARTNER_ACCOUNT_LOG_TYPE_SETTLE = 50;
    public static final String PARTNER_ACCOUNT_LOG_TYPE_SETTLE_REMARK = "月结发钱";
    public static final int PARTNER_ACCOUNT_LOG_TYPE_TECH_CHARGE = 80;
    public static final String PARTNER_ACCOUNT_LOG_TYPE_TECH_CHARGE_REMARK = "平台技术服务费";
    public static final int PARTNER_ACCOUNT_LOG_TYPE_TAX = 70;
    public static final String PARTNER_ACCOUNT_LOG_TYPE_TAX_REMARK = "代扣个人所得税";

    /**
     * 代理商奖励类型
     */
    public static final int AGENT_REWARD_TYPE_PURCHASE = 300;
    public static final int AGENT_REWARD_TYPE_SHARE = 60;

    public static final Date NEW_SETTLE_RULE_TIME = DateUtils.parse("2019-08-16 12:03:50");

    static {
        /**
         * 代理商平推奖励比例配置
         */
        AGENT_RATE_MAP.put(AGENT_REWARD_TYPE_YEAR_VIP, new HashMap<Integer, BigDecimal>());
//        AGENT_RATE_MAP.put(AGENT_REWARD_TYPE_HALF_YEAR_VIP, new HashMap<Integer, BigDecimal>());
//        AGENT_RATE_MAP.put(AGENT_REWARD_TYPE_SVIP, new HashMap<Integer, BigDecimal>());
        AGENT_RATE_MAP.put(AGENT_REWARD_TYPE_REDPACK, new HashMap<Integer, BigDecimal>());
        AGENT_RATE_MAP.put(AGENT_REWARD_TYPE_SELF_ORDER, new HashMap<Integer, BigDecimal>());
        AGENT_RATE_MAP.put(AGENT_REWARD_TYPE_SHARE_ORDER, new HashMap<Integer, BigDecimal>());
        AGENT_RATE_MAP.put(AGENT_REWARD_TYPE_SELF_ORDER + JD_OFFSET, new HashMap<Integer, BigDecimal>());
        AGENT_RATE_MAP.put(AGENT_REWARD_TYPE_SHARE_ORDER + JD_OFFSET, new HashMap<Integer, BigDecimal>());
        AGENT_RATE_MAP.put(AGENT_REWARD_TYPE_SELF_ORDER + MT_OFFSET, new HashMap<Integer, BigDecimal>());

        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_YEAR_VIP).put(0, new BigDecimal("0.02512563"));
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_YEAR_VIP).put(1, new BigDecimal("0.01507538"));

//        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_HALF_YEAR_VIP).put(0, new BigDecimal("0.03015075"));
//        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_HALF_YEAR_VIP).put(1, new BigDecimal("0.01256281"));
//        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_HALF_YEAR_VIP).put(2, new BigDecimal("0.00753769"));
//
//        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SVIP).put(0, new BigDecimal("0.02500000"));
//        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SVIP).put(1, new BigDecimal("0.01111111"));
//        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SVIP).put(2, new BigDecimal("0.00555556"));
        /**
         * 红包
         */
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_REDPACK).put(0, new BigDecimal("0.03"));
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_REDPACK).put(1, new BigDecimal("0.02"));
        /**
         * 自购省
         */
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SELF_ORDER).put(0, new BigDecimal("0.009"));
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SELF_ORDER).put(1, new BigDecimal("0.009"));
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SELF_ORDER + JD_OFFSET).put(0, new BigDecimal("0.0087"));
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SELF_ORDER + JD_OFFSET).put(1, new BigDecimal("0.0087"));
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SELF_ORDER + MT_OFFSET).put(0, new BigDecimal("0.01"));
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SELF_ORDER + MT_OFFSET).put(1, new BigDecimal("0.01"));
        /**
         * 分享赚
         */
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SHARE_ORDER).put(0, new BigDecimal("0.009"));
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SHARE_ORDER).put(1, new BigDecimal("0.009"));
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SHARE_ORDER + JD_OFFSET).put(0, new BigDecimal("0.0087"));
        AGENT_RATE_MAP.get(AGENT_REWARD_TYPE_SHARE_ORDER + JD_OFFSET).put(1, new BigDecimal("0.0087"));

        AGENT_REWARD_REMARK.put(AGENT_REWARD_TYPE_YEAR_VIP, AGENT_REWARD_TYPE_YEAR_VIP_REMARK);
//        AGENT_REWARD_REMARK.put(AGENT_REWARD_TYPE_HALF_YEAR_VIP, AGENT_REWARD_TYPE_HALF_YEAR_VIP_REMARK);
//        AGENT_REWARD_REMARK.put(AGENT_REWARD_TYPE_SVIP, AGENT_REWARD_TYPE_SVIP_REMARK);
        AGENT_REWARD_REMARK.put(AGENT_REWARD_TYPE_REDPACK, AGENT_REWARD_TYPE_REDPACK_REMARK);
        AGENT_REWARD_REMARK.put(AGENT_REWARD_TYPE_SELF_ORDER, AGENT_REWARD_TYPE_SELF_ORDER_REMARK);
        AGENT_REWARD_REMARK.put(AGENT_REWARD_TYPE_SHARE_ORDER, AGENT_REWARD_TYPE_SHARE_ORDER_REMARK);
        /**
         * 代理商奖励回扣类型
         */
        AGENT_REVOKE_TYPE_MAP.put(AGENT_REVOKE_TYPE_ACTIVATION, AGENT_REVOKE_TYPE_ACTIVATION_REMARK);
        AGENT_REVOKE_TYPE_MAP.put(AGENT_REVOKE_TYPE_SELF_ORDER, AGENT_REVOKE_TYPE_SELF_ORDER_REMARK);
        AGENT_REVOKE_TYPE_MAP.put(AGENT_REVOKE_TYPE_SHARE_ORDER, AGENT_REVOKE_TYPE_SHARE_ORDER_REMARK);
    }
}
