package com.lanren.huhu.partner.schedule;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.lanren.huhu.partner.domain.AgentExpandDetail;
import com.lanren.huhu.partner.domain.PartnerInviteRelation;
import com.lanren.huhu.partner.model.ParentAgent;
import com.lanren.huhu.partner.service.AgentExpandDailyService;
import com.lanren.huhu.partner.service.AgentExpandDetailService;
import com.lanren.huhu.partner.service.PartnerInviteRelationService;
import com.lanren.huhu.partner.service.UserService;
import com.lanren.huhu.partner.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

import static com.lanren.huhu.partner.constants.Constants.PARENT_COLUMN_NAME_CENGJI;

/**
 * @author chen
 * @title: AgentDailyExpandTask
 * @projectName partner
 * @description: 代理商每日拓展用户数,  按用户的代理商层次查找归属
 * @package com.lanren.huhu.partner.schedule
 * @date 2019-07-08 15:50
 */
@Component
public class AgentDailyExpandTask {
    private static Logger logger = LoggerFactory.getLogger(AgentDailyExpandTask.class);
    private static final int PAGE_SIZE = 1000;
    private static final long DELAY = 2 * 60 * 60 * 1000L;

    @Autowired
    PartnerInviteRelationService partnerInviteRelationService;
    @Autowired
    UserService userService;
    @Autowired
    AgentExpandDetailService agentExpandDetailService;
    @Autowired
    AgentExpandDailyService agentExpandDailyService;

//    @Scheduled(fixedDelay = DELAY)
    public void runScheduledTask() {
        try {
            Date dat = new Date(System.currentTimeMillis() - DELAY);
            String datStr = DateUtils.format(dat, DateUtils.FORMAT_SHORT);
            logger.info("run AgentDailyExpandTask {}", datStr);
            runSummary(datStr);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Async
    public void runSummary(String datStr) {
        try {
            Date dat = DateUtils.parse(datStr, DateUtils.FORMAT_SHORT);
            int now = (int)(System.currentTimeMillis() / 1000L);
            int pageNo = 1;
            int total = 0;
            int totalPage = 0;
            int cnt = 0;
            long beginTs = DateUtils.parse(datStr, DateUtils.FORMAT_SHORT).getTime() / 1000L;
            long endTs = beginTs + 24 * 60 * 60L - 1L;
            while (true) {
                Page<PartnerInviteRelation> page = new Page<PartnerInviteRelation>(pageNo, PAGE_SIZE);
                IPage<PartnerInviteRelation> ipage = partnerInviteRelationService.selectPageByTs(page, beginTs, endTs);
                if (total == 0) {
                    total = (int) ipage.getTotal();
                    totalPage = total % PAGE_SIZE == 0 ? total / PAGE_SIZE : total / PAGE_SIZE + 1;
                    logger.info("totalPage is {} ", totalPage);
                }
                List<PartnerInviteRelation> partnerInviteRelationList = ipage.getRecords();
                if (partnerInviteRelationList != null && partnerInviteRelationList.size() > 0) {
                    for (PartnerInviteRelation partnerInviteRelation : partnerInviteRelationList) {
                        List<ParentAgent> parentAgentList =  userService.getAgentListByUserId(partnerInviteRelation.getUserId(), PARENT_COLUMN_NAME_CENGJI);
                        for (ParentAgent parentAgent : parentAgentList) {
                            AgentExpandDetail detail = new AgentExpandDetail();
                            detail.setDat(dat);
                            detail.setAgentId(parentAgent.getAgentId());
                            detail.setUserId(parentAgent.getUserId());
                            detail.setExpandUserId(partnerInviteRelation.getUserId());
                            detail.setExpandUserRegTime(new Date(partnerInviteRelation.getRegiterTime() * 1000L));
                            detail.setCreatedAt(now);
                            detail.setUpdatedAt(now);
                            agentExpandDetailService.insertOrUpdate(detail);
                        }
                        cnt++;
                    }
                    if (partnerInviteRelationList.size() > 0) {
                        agentExpandDailyService.updateByDatByDetail(datStr);
                    }
                }
                if (pageNo >= totalPage) {
                    break;
                }
                pageNo++;
            }
            logger.info("cnt is {}", cnt);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }
}
