package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@TableName(value = "partner_reward")
public class PartnerReward implements Serializable {
    /**
     * ID序号
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户id
     */
    @TableField(value = "user_id")
    private Integer userId;

    /**
     * 用户是否是超级
     */
    @TableField(value = "user_is_super")
    private Integer userIsSuper;

    /**
     * 用户合伙人级别 普通10 高级20
     */
    @TableField(value = "user_partner_level")
    private Integer userPartnerLevel;

    /**
     * 合伙人奖励类型 60 用户在线充值 70 升高开户充值,80邀请奖励,90下单奖励,100购买超级VIP会员,110购物奖励
     */
    @TableField(value = "reward_type")
    private Integer rewardType;

    /**
     * 子类型 good_friend:好友奖励
     */
    @TableField(value = "reward_type_child")
    private String rewardTypeChild;

    /**
     * 状态 100待结算 120 已结算
     */
    @TableField(value = "reward_status")
    private Integer rewardStatus;

    /**
     * 分红金额
     */
    @TableField(value = "commission_acount")
    private BigDecimal commissionAcount;

    /**
     * 分红比例
     */
    @TableField(value = "commission_rate")
    private BigDecimal commissionRate;

    /**
     * order id
     */
    @TableField(value = "reference_id")
    private String referenceId;

    /**
     * 用户充值时间
     */
    @TableField(value = "recharge_time")
    private Date rechargeTime;

    /**
     * 面值
     */
    @TableField(value = "price")
    private BigDecimal price;

    /**
     * 奖励基数(充值支付金额 或 淘宝京东原始佣金)
     */
    @TableField(value = "cash")
    private BigDecimal cash;

    /**
     * 源用户id
     */
    @TableField(value = "source_user_id")
    private Integer sourceUserId;

    /**
     * 源用户级别
     */
    @TableField(value = "source_user_level")
    private Integer sourceUserLevel;

    /**
     * 源用户邀请人id
     */
    @TableField(value = "invite_user_id")
    private Integer inviteUserId;

    /**
     * 源用户邀请人级别 普通10 高级20
     */
    @TableField(value = "invite_user_level")
    private Integer inviteUserLevel;

    /**
     * 源原用户邀请人是否超级 1是 0否
     */
    @TableField(value = "invite_user_is_super")
    private Integer inviteUserIsSuper;

    @TableField(value = "created_at")
    private Long createdAt;

    @TableField(value = "updated_at")
    private Long updatedAt;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 是直接还是间接邀请人 10直接 20间接 30自己
     */
    @TableField(value = "source_type")
    private Integer sourceType;

    /**
     * 第?笔下单激活奖励
     */
    @TableField(value = "reward_times")
    private Integer rewardTimes;

    /**
     * 结算状态 100在路上 200预结算 300已结算 -100在路上已失效 -200预结算已失效 -300已结算扣回
     */
    @TableField(value = "settle_state")
    private Integer settleState;

    /**
     * 商品ID
     */
    @TableField(value = "goods_id")
    private String goodsId;

    /**
     * 商品标题
     */
    @TableField(value = "title")
    private String title;

    /**
     * 订单类型
     */
    @TableField(value = "order_type")
    private String orderType;

    /**
     * 订单号
     */
    @TableField(value = "order_sn")
    private String orderSn;

    /**
     * 子订单号
     */
    @TableField(value = "sub_order_sn")
    private String subOrderSn;

    /**
     * 来源基础金额
     */
    @TableField(value = "all_money_ori")
    private BigDecimal allMoneyOri;

    /**
     * 该金额所有的计算比率值
     */
    @TableField(value = "ratio_all")
    private String ratioAll;

    @TableField(value = "is_show_on_client")
    private Boolean isShowOnClient;

    /**
     * 技术服务费扣除比例
     */
    @TableField(value = "tech_fee_rate")
    private BigDecimal techFeeRate;

    /**
     * 结算奖励的时间: 淘宝客/京东联盟为确认收货时间, 其他类型奖励同于recharge_time
     */
    @TableField(value = "settle_time")
    private Date settleTime;

    /**
     * 是否提前结算: 1是,0否
     */
    @TableField(value = "settle_in_advance")
    private Integer settleInAdvance;

    private static final long serialVersionUID = 1L;

    public static final String COL_USER_ID = "user_id";

    public static final String COL_USER_IS_SUPER = "user_is_super";

    public static final String COL_USER_PARTNER_LEVEL = "user_partner_level";

    public static final String COL_REWARD_TYPE = "reward_type";

    public static final String COL_REWARD_TYPE_CHILD = "reward_type_child";

    public static final String COL_REWARD_STATUS = "reward_status";

    public static final String COL_COMMISSION_ACOUNT = "commission_acount";

    public static final String COL_COMMISSION_RATE = "commission_rate";

    public static final String COL_REFERENCE_ID = "reference_id";

    public static final String COL_RECHARGE_TIME = "recharge_time";

    public static final String COL_PRICE = "price";

    public static final String COL_CASH = "cash";

    public static final String COL_SOURCE_USER_ID = "source_user_id";

    public static final String COL_SOURCE_USER_LEVEL = "source_user_level";

    public static final String COL_INVITE_USER_ID = "invite_user_id";

    public static final String COL_INVITE_USER_LEVEL = "invite_user_level";

    public static final String COL_INVITE_USER_IS_SUPER = "invite_user_is_super";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";

    public static final String COL_CREATE_TIME = "create_time";

    public static final String COL_SOURCE_TYPE = "source_type";

    public static final String COL_REWARD_TIMES = "reward_times";

    public static final String COL_SETTLE_STATE = "settle_state";

    public static final String COL_GOODS_ID = "goods_id";

    public static final String COL_TITLE = "title";

    public static final String COL_ORDER_TYPE = "order_type";

    public static final String COL_ORDER_SN = "order_sn";

    public static final String COL_SUB_ORDER_SN = "sub_order_sn";

    public static final String COL_ALL_MONEY_ORI = "all_money_ori";

    public static final String COL_RATIO_ALL = "ratio_all";

    public static final String COL_IS_SHOW_ON_CLIENT = "is_show_on_client";

    public static final String COL_TECH_FEE_RATE = "tech_fee_rate";

    public static final String COL_SETTLE_TIME = "settle_time";

    public static final String COL_SETTLE_IN_ADVANCE = "settle_in_advance";
}