package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

@Data
@TableName(value = "partner_purchase_reward_record")
public class PartnerPurchaseRewardRecord implements Serializable {
    /**
     * 主键
     */
     @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 贡献人ID
     */
    @TableField(value = "user_id")
    private Integer userId;

    /**
     * 贡献人级别快照 默认0 普通10 高级20 超级30
     */
    @TableField(value = "user_level")
    private Integer userLevel;

    /**
     * 激活的订单号
     */
    @TableField(value = "active_order_id")
    private String activeOrderId;

    /**
     * 激活得订单号类型
     */
    @TableField(value = "active_order_type")
    private String activeOrderType;

    /**
     * 激活得订单号金额
     */
    @TableField(value = "active_order_cash")
    private BigDecimal activeOrderCash;

    /**
     * 购物返现比例
     */
    @TableField(value = "active_return_cash_proportion")
    private BigDecimal activeReturnCashProportion;

    /**
     * 直接邀请人ID
     */
    @TableField(value = "invite_user_id")
    private Integer inviteUserId;

    /**
     * 直接奖励类型 默认0、10现金 20 红包
     */
    @TableField(value = "invite_reward_type")
    private Integer inviteRewardType;

    /**
     * 直接级别快照 默认0 普通10 高级20 超级30
     */
    @TableField(value = "invite_partner_level")
    private Integer invitePartnerLevel;

    /**
     * 直接奖励金额
     */
    @TableField(value = "invite_amout")
    private BigDecimal inviteAmout;

    /**
     * 奖励类型  0 默认 10 直接 20 间接
     */
    @TableField(value = "reward_type")
    private Integer rewardType;

    /**
     * 100待奖励 ;120已结算
     */
    @TableField(value = "reward_state")
    private Integer rewardState;

    /**
     * 激活时间
     */
    @TableField(value = "active_time")
    private Integer activeTime;

    /**
     * 创建时间
     */
    @TableField(value = "created_at")
    private Integer createdAt;

    /**
     * 修改时间
     */
    @TableField(value = "updated_at")
    private Integer updatedAt;

    private static final long serialVersionUID = 1L;

    public static final String COL_USER_ID = "user_id";

    public static final String COL_USER_LEVEL = "user_level";

    public static final String COL_ACTIVE_ORDER_ID = "active_order_id";

    public static final String COL_ACTIVE_ORDER_TYPE = "active_order_type";

    public static final String COL_ACTIVE_ORDER_CASH = "active_order_cash";

    public static final String COL_ACTIVE_RETURN_CASH_PROPORTION = "active_return_cash_proportion";

    public static final String COL_INVITE_USER_ID = "invite_user_id";

    public static final String COL_INVITE_REWARD_TYPE = "invite_reward_type";

    public static final String COL_INVITE_PARTNER_LEVEL = "invite_partner_level";

    public static final String COL_INVITE_AMOUT = "invite_amout";

    public static final String COL_REWARD_TYPE = "reward_type";

    public static final String COL_REWARD_STATE = "reward_state";

    public static final String COL_ACTIVE_TIME = "active_time";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";
}