package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@TableName(value = "partner_account_log")
public class PartnerAccountLog implements Serializable {
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户id
     */
    @TableField(value = "user_id")
    private Integer userId;

    /**
     * 年份
     */
    @TableField(value = "yeartime")
    private Integer yeartime;

    /**
     * 月份
     */
    @TableField(value = "monthtime")
    private Integer monthtime;

    /**
     * 每日日期
     */
    @TableField(value = "daytime")
    private Integer daytime;

    /**
     * 变化类型 10 微信 20支付宝 30 银联 40 银行卡 、50呼呼结算、60首月奖励 、70税费、80平台服务费、90平台扣除
     */
    @TableField(value = "type")
    private Integer type;

    /**
     * 变化的金额 进账为正数 出账为负数
     */
    @TableField(value = "change_num")
    private BigDecimal changeNum;

    /**
     * 变化的之后的金额
     */
    @TableField(value = "changed_amount")
    private BigDecimal changedAmount;

    /**
     * 变更的当前时间戳 秒级
     */
    @TableField(value = "change_time")
    private Integer changeTime;

    /**
     * 状态 20是已经处理（充值后者减值，10是待处理）
     */
    @TableField(value = "pay_state")
    private Integer payState;

    /**
     * 支付平台 系统hupay、微信wxpay、支付宝 alipay 、银联支付 unionpay 、银行卡cardpay
     */
    @TableField(value = "pay_platform")
    private String payPlatform;

    /**
     * 支付类型，10充值，20消费，30提现，40退款, 50合伙人奖励，60充值奖励，70 激活现金，80提现回退,90系统赠送,100系统扣除,110呼呼按月结算，120首月奖励
     */
    @TableField(value = "pay_type")
    private Boolean payType;

    /**
     * 类型描述 与pay_type 对应
     */
    @TableField(value = "pay_remark")
    private String payRemark;

    /**
     * 文字描述
     */
    @TableField(value = "pay_info")
    private String payInfo;

    /**
     * 参考ID 就是发生变化的订单id  支付 充值 提现、奖励的主键id
     */
    @TableField(value = "reference_id")
    private String referenceId;

    @TableField(value = "create_time")
    private LocalDateTime createTime;

    @TableField(value = "modify_time")
    private LocalDateTime modifyTime;

    /**
     * 变更前的快照
     */
    @TableField(value = "snapshot")
    private String snapshot;

    private static final long serialVersionUID = 1L;

    public static final String COL_USER_ID = "user_id";

    public static final String COL_YEARTIME = "yeartime";

    public static final String COL_MONTHTIME = "monthtime";

    public static final String COL_DAYTIME = "daytime";

    public static final String COL_TYPE = "type";

    public static final String COL_CHANGE_NUM = "change_num";

    public static final String COL_CHANGED_AMOUNT = "changed_amount";

    public static final String COL_CHANGE_TIME = "change_time";

    public static final String COL_PAY_STATE = "pay_state";

    public static final String COL_PAY_PLATFORM = "pay_platform";

    public static final String COL_PAY_TYPE = "pay_type";

    public static final String COL_PAY_REMARK = "pay_remark";

    public static final String COL_PAY_INFO = "pay_info";

    public static final String COL_REFERENCE_ID = "reference_id";

    public static final String COL_CREATE_TIME = "create_time";

    public static final String COL_MODIFY_TIME = "modify_time";

    public static final String COL_SNAPSHOT = "snapshot";
}