package com.lanren.huhu.partner.util;

import com.lanren.huhu.partner.service.LockService;

import java.util.concurrent.TimeUnit;

/**
 * @author chen
 * @title: LockUtil
 * @projectName partner
 * @description: 分布式锁工具类
 * @package com.lanren.huhu.partner.util
 * @date 2019-07-01 19:39
 */
public class LockUtil {
    private static LockService lockService;

    /**
     * 设置工具类使用的locker
     * @param lockService
     */
    public static void setLockService(LockService lockService) {
        LockUtil.lockService = lockService;
    }

    /**
     * 获取锁
     * @param lockKey
     */
    public static void lock(String lockKey) {
        try {
            lockService.lock(lockKey);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 释放锁
     * @param lockKey
     */
    public static void unlock(String lockKey) {
        lockService.unlock(lockKey);
    }

    /**
     * 获取锁，超时释放
     * @param lockKey
     * @param timeout
     */
    public static void lock(String lockKey, int timeout) {
        lockService.lock(lockKey, timeout);
    }

    /**
     * 获取锁，超时释放，指定时间单位
     * @param lockKey
     * @param unit
     * @param timeout
     */
    public static void lock(String lockKey, TimeUnit unit, int timeout) {
        lockService.lock(lockKey, unit, timeout);
    }

    /**
     * 尝试获取锁，获取到立即返回true,获取失败立即返回false
     * @param lockKey
     * @return
     */
    public static boolean tryLock(String lockKey) {
        return lockService.tryLock(lockKey);
    }

    /**
     * 尝试获取锁，在给定的waitTime时间内尝试，获取到返回true,获取失败返回false,获取到后再给定的leaseTime时间超时释放
     * @param lockKey
     * @param waitTime
     * @param leaseTime
     * @param unit
     * @return
     * @throws InterruptedException
     */
    public static boolean tryLock(String lockKey, long waitTime, long leaseTime,
                                  TimeUnit unit) throws InterruptedException {
        return lockService.tryLock(lockKey, waitTime, leaseTime, unit);
    }

    /**
     * 锁释放被任意一个线程持有
     * @param lockKey
     * @return
     */
    public static boolean isLocked(String lockKey) {
        return lockService.isLocked(lockKey);
    }
}
