package com.lanren.huhu.partner.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.lanren.huhu.partner.dao.PartnerAccountMapper;
import com.lanren.huhu.partner.domain.PartnerAccount;
import com.lanren.huhu.partner.service.PartnerAccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author houseme
 */
@Service
public class PartnerAccountServiceImpl extends ServiceImpl<PartnerAccountMapper, PartnerAccount> implements PartnerAccountService {
    @Autowired
    PartnerAccountMapper partnerAccountMapper;

    @Override
    public int updateBatch(List<PartnerAccount> list) {
        return baseMapper.updateBatch(list);
    }

    @Override
    public int batchInsert(List<PartnerAccount> list) {
        return baseMapper.batchInsert(list);
    }

    @Override
    public int insertOrUpdate(PartnerAccount record) {
        return baseMapper.insertOrUpdate(record);
    }

    @Override
    public int insertOrUpdateSelective(PartnerAccount record) {
        return baseMapper.insertOrUpdateSelective(record);
    }

    @Override
    public PartnerAccount getOneByUserId(Integer userId) {
        QueryWrapper<PartnerAccount> queryWrapper = new QueryWrapper<PartnerAccount>();
        queryWrapper.eq("user_id", userId);
        return baseMapper.selectOne(queryWrapper);
    }
    @Override
    public PartnerAccount getOneByUserIdForUpdate(Integer userId) {
        return baseMapper.selectOneForUpdate(userId);
    }
}
