package com.lanren.huhu.partner.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.lanren.huhu.partner.dao.PartnerAccountLogMapper;
import com.lanren.huhu.partner.domain.PartnerAccountLog;
import com.lanren.huhu.partner.service.PartnerAccountLogService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author chen
 * @title: ${NAME}
 * @projectName partner
 * @description: 合伙人账户明细
 * @package ${PACKAGE_N @date 2019-07-02 15:57
 */
@Service
public class PartnerAccountLogServiceImpl extends ServiceImpl<PartnerAccountLogMapper, PartnerAccountLog> implements PartnerAccountLogService {

    @Override
    public int updateBatch(List<PartnerAccountLog> list) {
        return baseMapper.updateBatch(list);
    }

    @Override
    public int batchInsert(List<PartnerAccountLog> list) {
        return baseMapper.batchInsert(list);
    }

    @Override
    public int insertOrUpdate(PartnerAccountLog record) {
        return baseMapper.insertOrUpdate(record);
    }

    @Override
    public int insertOrUpdateSelective(PartnerAccountLog record) {
        return baseMapper.insertOrUpdateSelective(record);
    }

    @Override
    public PartnerAccountLog getOneByUidAndDay(int userId, int yeartime, int monthtime, int daytime) {
//        SELECT user_id,change_num
//        FROM huhu_finance.partner_account_log
//        WHERE yeartime=#{yeartime} AND monthtime=#{monthtime} AND daytime=#{daytime}
//        AND user_id = #{userId}
//        AND type=50
        QueryWrapper<PartnerAccountLog> wrapper = new QueryWrapper<PartnerAccountLog>();
        wrapper.eq("user_id", userId)
                .eq("yeartime", yeartime)
                .eq("monthtime", monthtime)
                .eq("daytime", daytime)
                .eq("type", 50);
        return baseMapper.selectOne(wrapper);
    }
}


