package com.lanren.huhu.partner.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.lanren.huhu.partner.dao.OrdersActiveMapper;
import com.lanren.huhu.partner.domain.OrdersActive;
import com.lanren.huhu.partner.model.OrderParam;
import com.lanren.huhu.partner.service.OrdersActiveService;
import org.springframework.stereotype.Service;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
    * @title: ${NAME}
    * @projectName partner
    * @description: TODO
    * @author chen
    * @package ${PACKAGE_NAME}
    * @date 2019-07-17 16:59
    */
@Service
public class OrdersActiveServiceImpl extends ServiceImpl<OrdersActiveMapper, OrdersActive> implements OrdersActiveService{

    @Override
    public int updateBatch(List<OrdersActive> list) {
        return baseMapper.updateBatch(list);
    }
    @Override
    public int batchInsert(List<OrdersActive> list) {
        return baseMapper.batchInsert(list);
    }
    @Override
    public int insertOrUpdate(OrdersActive record) {
        return baseMapper.insertOrUpdate(record);
    }
    @Override
    public int insertOrUpdateSelective(OrdersActive record) {
        return baseMapper.insertOrUpdateSelective(record);
    }

    @Override
    public List<OrdersActive> selectListByOrderParamSet(Set<OrderParam> orderParamSet) {
        QueryWrapper<OrdersActive> wrapper = new QueryWrapper<OrdersActive>();
        Iterator<OrderParam> iterator = orderParamSet.iterator();
        for (int idx = 0; idx < orderParamSet.size(); idx++) {
            OrderParam order = iterator.next();
            wrapper.nested(i -> i.eq("type", order.getOrderType())
                    .eq("order_sn", order.getOrderSn()));
            if (idx < orderParamSet.size() - 1) {
                wrapper.or();
            }
        }
        return baseMapper.selectList(wrapper);
    }
}
