package com.lanren.huhu.partner.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.lanren.huhu.partner.dao.AgentRewardMapper;
import com.lanren.huhu.partner.domain.AgentReward;
import com.lanren.huhu.partner.model.AgentSettle;
import com.lanren.huhu.partner.service.AgentRewardService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author chen
 * @title: ${NAME}
 * @projectName partner
 * @description: 代理商奖励明细
 * @package ${PACKAGE_NAME}
 * @date 2019-06-29 18:49
 */
@Service
public class AgentRewardServiceImpl extends ServiceImpl<AgentRewardMapper, AgentReward> implements AgentRewardService {

    @Override
    public int updateBatch(List<AgentReward> list) {
        return baseMapper.updateBatch(list);
    }

    @Override
    public int batchInsert(List<AgentReward> list) {
        return baseMapper.batchInsert(list);
    }

    @Override
    public int insertOrUpdate(AgentReward record) {
        return baseMapper.insertOrUpdate(record);
    }

    @Override
    public int insertOrUpdateSelective(AgentReward record) {
        return baseMapper.insertOrUpdateSelective(record);
    }

    @Override
    public List<AgentReward> getListByRefId(String refId) {
        QueryWrapper<AgentReward> wrapper = new QueryWrapper<AgentReward>();
        wrapper.eq("reference_id", refId).gt("settle_state", 0);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public List<AgentReward> getListBySubOrderSn(String orderType, String orderSn, String subOrderSn) {
        QueryWrapper<AgentReward> wrapper = new QueryWrapper<AgentReward>();
        wrapper.eq("order_type", orderType).eq("order_sn", orderSn).eq("sub_order_sn", subOrderSn)
                .gt("settle_state", 0);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public int insertOne(AgentReward record) {
        List<AgentReward> list = new ArrayList<AgentReward>();
        list.add(record);
        return batchInsert(list);
    }

    @Override
    public AgentSettle selectAgentSettleByTsAndAgentId(long beginTs, long endTs, Integer agentId) {
        return baseMapper.selectAgentSettleByTsAndAgentId(beginTs, endTs, agentId);
    }

    @Override
    public IPage<AgentReward> selectOrderRewardPageByTs(Page<AgentReward> page, long beginTs, long endTs) {
        return baseMapper.selectOrderRewardPageByTs(page, beginTs, endTs);
    }

    @Override
    public IPage<AgentReward> selectOrderRewardPageByTsAndAgentId(Page<AgentReward> page, long beginTs, long endTs, int agentId) {
        return baseMapper.selectOrderRewardPageByTsAndAgentId(page, beginTs, endTs, agentId);
    }

    @Override
    public int updateRewardStatusByUidAndTs(int agentId, long beginTs, long endTs) {
        return baseMapper.updateRewardStatusByAgentIdAndTs(agentId, beginTs, endTs);
    }

    @Override
    public IPage<AgentSettle> selectAgentSettlePageByTs(Page<AgentSettle> page, long beginTs, long endTs) {
        return baseMapper.selectAgentSettlePageByTs(page, beginTs, endTs);
    }
}






