package com.lanren.huhu.partner.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.lanren.huhu.partner.dao.AgentRevokeRecordsMapper;
import com.lanren.huhu.partner.domain.AgentRevokeRecords;
import com.lanren.huhu.partner.service.AgentRevokeRecordsService;
import org.springframework.stereotype.Service;

import java.util.List;

import static com.lanren.huhu.partner.constants.Constants.REVOKE_STATE_PENDING;

/**
    * @title: ${NAME}
    * @projectName partner
    * @author chen
    * @package ${PACKAGE_NAME}
    * @date 2019-07-04 11:44
    */
@Service
public class AgentRevokeRecordsServiceImpl extends ServiceImpl<AgentRevokeRecordsMapper, AgentRevokeRecords> implements AgentRevokeRecordsService{
    @Override
    public int updateBatch(List<AgentRevokeRecords> list) {
        return baseMapper.updateBatch(list);
    }
    @Override
    public int batchInsert(List<AgentRevokeRecords> list) {
        return baseMapper.batchInsert(list);
    }
    @Override
    public int insertOrUpdate(AgentRevokeRecords record) {
        return baseMapper.insertOrUpdate(record);
    }
    @Override
    public int insertOrUpdateSelective(AgentRevokeRecords record) {
        return baseMapper.insertOrUpdateSelective(record);
    }

    @Override
    public List<AgentRevokeRecords> getAllPending() {
        QueryWrapper<AgentRevokeRecords> wrapper = new QueryWrapper<AgentRevokeRecords>();
        wrapper.eq("state", REVOKE_STATE_PENDING).orderByAsc("updated_at");
        return baseMapper.selectList(wrapper);
    }
}
