package com.lanren.huhu.partner.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.lanren.huhu.partner.dao.AgentBankCardMapper;
import com.lanren.huhu.partner.domain.AgentBankCard;
import com.lanren.huhu.partner.service.AgentBankCardService;
import org.springframework.stereotype.Service;

import java.util.List;
/**  
    * @title: ${NAME}
    * @projectName partner
    * @description: 代理商开卡记录
    * @author chen
    * @package ${PACKAGE_NAME}
 @date 2019-07-02 15:59
    */
@Service
public class AgentBankCardServiceImpl extends ServiceImpl<AgentBankCardMapper, AgentBankCard> implements AgentBankCardService{

    @Override
    public int updateBatch(List<AgentBankCard> list) {
        return baseMapper.updateBatch(list);
    }
    @Override
    public int batchInsert(List<AgentBankCard> list) {
        return baseMapper.batchInsert(list);
    }
    @Override
    public int insertOrUpdate(AgentBankCard record) {
        return baseMapper.insertOrUpdate(record);
    }
    @Override
    public int insertOrUpdateSelective(AgentBankCard record) {
        return baseMapper.insertOrUpdateSelective(record);
    }
    @Override
    public AgentBankCard getOneByAgentId(int agentId) {
        QueryWrapper<AgentBankCard> wrapper = new QueryWrapper<AgentBankCard>();
        wrapper.eq("agent_id", agentId).eq("is_default", 100);
        return baseMapper.selectOne(wrapper);
    }
}
