package com.lanren.huhu.partner.model;

import com.lanren.huhu.partner.model.base.BaseModel;
import lombok.Data;

/**
 * @author chen
 * @title: SubSubOrderParam
 * @projectName partner
 * @package com.lanren.huhu.partner.model
 * @date 2019-08-20 19:51
 */
@Data
public class SubOrderParam extends BaseModel {
    private String orderType;
    private String orderSn;
    private String subOrderSn;

    @Override
    public boolean equals(Object obj) {
        if(obj==null) {
            return false;
        }
        if(this==obj) {
            return true;
        }
        if(obj instanceof SubOrderParam){
            SubOrderParam orderParam = (SubOrderParam) obj;
            if(orderParam.orderType.equals(this.orderType) &&
                    orderParam.orderSn.equals(this.orderSn) &&
                    orderParam.subOrderSn.equals(this.subOrderSn)) {
                return true;
            } else {
                return false;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(orderType);
        sb.append(orderSn);
        sb.append(subOrderSn);
        char[] charArr = sb.toString().toCharArray();
        int hash = 0;

        for(char c : charArr) {
            hash = hash * 131 + c;
        }
        return hash;
    }
}
