package com.lanren.huhu.partner.model;

import com.lanren.huhu.partner.model.base.BaseModel;
import lombok.Data;

/**
 * @author chen
 * @title: OrderParam
 * @projectName partner
 * @package com.lanren.huhu.partner.model
 * @date 2019-08-20 19:50
 */
@Data
public class OrderParam extends BaseModel {
    private String orderType;
    private String orderSn;

    @Override
    public boolean equals(Object obj) {
        if(obj==null) {
            return false;
        }
        if(this==obj) {
            return true;
        }
        if(obj instanceof OrderParam){
            OrderParam orderParam = (OrderParam) obj;
            if(orderParam.orderType.equals(this.orderType) &&
                    orderParam.orderSn.equals(this.orderSn)) {
                return true;
            } else {
                return false;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(orderType);
        sb.append(orderSn);
        char[] charArr = sb.toString().toCharArray();
        int hash = 0;

        for(char c : charArr) {
            hash = hash * 131 + c;
        }
        return hash;
    }
}
