package com.lanren.huhu.partner.model;

import com.lanren.huhu.partner.model.base.BaseModel;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author chen
 * @title: AgentRewardMessage
 * @projectName partner
 * @description: 代理商奖励处理 Redis队列消息结构
 * @package com.lanren.huhu.partner.model
 * @date 2019-06-29 12:29
 */
@Data
public class AgentRewardMessage extends BaseModel {
    int rewardType;
    String rechargeTime;
    int sourceUserId;
    String referenceId;
    int agentId;
//    BigDecimal agentReward;
    int settleState;
    String orderType;
    String orderSn;
    String subOrderSn;
    BigDecimal orderCommission;
    BigDecimal sourceUserPayment;
    String orderGoodsId;
    String orderTitle;
    String rewardTypeChild;
//    String orderRateArray;
    String sourceOrder;

    @Override
    public AgentRewardMessage clone() {
        AgentRewardMessage one = new AgentRewardMessage();
        one.rewardType = this.rewardType;
        one.rechargeTime = this.rechargeTime;
        one.sourceUserId = this.sourceUserId;
        one.referenceId = this.referenceId;
        one.agentId = this.agentId;
//        one.agentReward = this.agentReward;
        one.settleState = this.settleState;
        one.orderType = this.orderType;
        one.orderSn = this.orderSn;
        one.subOrderSn = this.subOrderSn;
        one.orderCommission = this.orderCommission;
        one.sourceUserPayment = this.sourceUserPayment;
        one.orderGoodsId = this.orderGoodsId;
        one.orderTitle = this.orderTitle;
        one.rewardTypeChild = this.rewardTypeChild;
//        one.orderRateArray = this.orderRateArray;
        one.sourceOrder = this.sourceOrder;
        return one;
    }
}
